package com.biz.crm.kms.business.statement.local.controller;



import com.biz.crm.kms.business.statement.sdk.service.ExposureVoService;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.statement.sdk.vo.ExposureVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
 * 敞口管理Vo(ExposureVo)表相关的http接口
 *
 * @author zs
 * @since 2022-11-05 15:59:19
 */
@RestController
@RequestMapping("/v1/exposureVo/exposureVo")
@Slf4j
@Api(tags = "敞口管理")
public class ExposureVoController {
  /**
  * 服务对象
  */
  @Autowired
  private ExposureVoService exposureVoService;
  
  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param exposureVo 查询实体
   * @return 所有数据
  */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<ExposureVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                   @ApiParam(name = "exposureVo", value = "敞口管理Vo") ExposureVo exposureVo) {
    try {
      Page<ExposureVo> page =  this.exposureVoService.findByConditions(pageable,exposureVo);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
  */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<ExposureVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      ExposureVo exposureVo = this.exposureVoService.findById(id);
      return Result.ok(exposureVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据商超系统查找敞口信息
   * @param supermarketCode
   * @return
   */
  @ApiOperation("根据商超系统查找敞口信息")
  @GetMapping("findBySupermarket")
  public Result<List<ExposureVo>> findBySupermarket(@RequestParam String supermarketCode,@RequestParam String supermarketName){
    try {
      List<ExposureVo> voList = this.exposureVoService.findBySupermarket(supermarketCode, supermarketName);
      return Result.ok(voList);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 新增数据
   *
   * @param exposureVo 实体对象
   * @return 新增结果
  */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<ExposureVo> create(@ApiParam(name = "exposureVo", value = "敞口管理Vo") @RequestBody ExposureVo exposureVo) {
    try {
      ExposureVo result = this.exposureVoService.create(exposureVo);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 修改数据
   *
   * @param exposureVo 实体对象
   * @return 修改结果
  */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<ExposureVo> update(@ApiParam(name = "exposureVo", value = "敞口管理Vo") @RequestBody ExposureVo exposureVo) {
    try {
      ExposureVo result = this.exposureVoService.update(exposureVo);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 删除数据（单个或者批量）
   *
   * @param ids 主键集合
   * @return 删除结果
   */
  @DeleteMapping
  @ApiOperation(value = "删除数据（单个或者批量）")
  public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
    try {
      this.exposureVoService.delete(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 启用（单个或者批量）
   *
   * @param ids 主键结合
   * @return 启用结果
   */
  @PatchMapping("enable")
  @ApiOperation(value = "启用（单个或者批量）")
  public Result<?> enable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.exposureVoService.enable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 禁用（单个或者批量）
   *
   * @param ids 主键结合
   * @return 禁用结果
   */
  @PatchMapping("disable")
  @ApiOperation(value = "禁用（单个或者批量）")
  public Result<?> disable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.exposureVoService.disable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  /**
   * 同步SAP数据
   */
  @ApiOperation(value = "同步SAP数据")
  @PostMapping("synchronize")
  public Result<?> synchronize() {
    try {
      this.exposureVoService.synchronize();
      return Result.ok("同步成功！");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "信贷发送接口")
  @GetMapping("toSD")
  public void toSd(){
    this.exposureVoService.toSD();
  }

  /**
   * 定时同步SD120
   */
  @ApiOperation(value = "定时同步SD120")
  @PostMapping("synchronize120")
  public Result<?> synchronize120() {
    try {
      this.exposureVoService.updateSD();
      return Result.ok("同步成功！");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
