package com.biz.crm.kms.business.statement.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

@ApiModel(value = "ExposureEntity", description = "KMS-敞口管理")
@TableName("kms_exposure")
@Getter
@Setter
@Entity(name = "kms_exposure")
@Table(name = "kms_exposure")
@org.hibernate.annotations.Table(appliesTo = "kms_exposure", comment = "KMS-敞口管理")
public class ExposureEntity extends TenantFlagOpEntity {


    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty(name = "业务单元", notes = "")
    @Column(name = "business_unit_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元'")
    private String businessUnitCode;

    /**
     * 系统编码
     */
    @ApiModelProperty("系统编码")
    @Column(name = "direct_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '系统编码'")
    private String directCode;

    /**
     * 系统编码
     */
    @ApiModelProperty("系统名称")
    @Column(name = "direct_name", length = 64, columnDefinition = "varchar(64) COMMENT '系统编码'")
    private String directName;

    /**
     * 零售商编码
     */
    @ApiModelProperty(value = "零售商编码")
    @Column(name = "supermarket_code", length = 32,  columnDefinition = "varchar(32) COMMENT '零售商编码'")
    private String supermarketCode;

    /**
     * 商超系统名称
     */
    @ApiModelProperty(value = "商超系统名称")
    @Column(name = "supermarket_name",  columnDefinition = "varchar(255) COMMENT '系统名称'")
    private String supermarketName;

    /**
     * 售达方编码
     */
    @ApiModelProperty(value = "售达方编码")
    @Column(name = "sell_party_code", length = 32, columnDefinition = "varchar(32) COMMENT '售达方编码'")
    private String sellPartyCode;

    /**
     * 售达方名称
     */
    @ApiModelProperty(value = "售达方名称")
    @Column(name = "sell_party_name", length = 255, columnDefinition = "varchar(255) COMMENT '售达方名称'")
    private String sellPartyName;

    /**
     * 初始敞口额度
     */
    @ApiModelProperty("信贷额度")
    @Column(name = "exposure_initial", columnDefinition = "Decimal(16,6) COMMENT '售达方名称'")
    private BigDecimal exposureInitial;

    /**
     * SAP剩余信贷额度
     */
    @ApiModelProperty("SAP剩余信贷额度")
    @Column(name = "sap_exposure_current", columnDefinition = "Decimal(16,6) COMMENT 'SAP剩余信贷额度'")
    private BigDecimal sapExposureCurrent;
    /**
     * 已占用敞口额度
     */
    @ApiModelProperty("已占用敞口额度")
    @Column(name = "exposure_current", columnDefinition = "Decimal(16,6) COMMENT '已占用敞口额度'")
    private BigDecimal exposureCurrent;

    /**
     * 剩余信贷额度
     */
    @ApiModelProperty("剩余信贷额度")
    @Column(name = "remaining_credit_line", columnDefinition = "Decimal(16,6) COMMENT '剩余信贷额度'")
    private BigDecimal remainingCreditLine;

    /**
     * 信贷风险总额
     */
    @ApiModelProperty("信贷风险总额")
    @Column(name = "total_credit_risk", columnDefinition = "Decimal(16,6) COMMENT '信贷风险总额'")
    private BigDecimal totalCreditRisk;

    /**
     * 费用池余额
     */
    @ApiModelProperty("费用池余额")
    @Column(name = "fee_pool_balence", columnDefinition = "Decimal(16,6) COMMENT '费用池余额'")
    private BigDecimal feePoolBalence;

    /**
     * 应收总额
     */
    @ApiModelProperty("应收总额")
    @Column(name = "total_receivables", columnDefinition = "Decimal(16,6) COMMENT '应收总额'")
    private BigDecimal totalReceivables;

    /**
     * 销售值
     */
    @ApiModelProperty("销售值")
    @Column(name = "sales_amount", columnDefinition = "Decimal(16,6) COMMENT '销售值'")
    private BigDecimal salesAmount;
}
