package com.biz.crm.kms.business.statement.local.entity;

import cn.hutool.core.lang.UUID;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.bizunited.nebula.common.entity.TenantOpEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author cyj
 * @version 1.0
 * @date 2023/2/20 16:05
 * @description KmsSD120Entity
 */
@ApiModel(value = "KmsSD120Entity", description = "KMS信贷数据表")
@TableName("kms_sd120")
@Getter
@Setter
@Entity(name = "kms_sd120")
@Table(name = "kms_sd120")
@org.hibernate.annotations.Table(appliesTo = "kms_sd120", comment = "KMS信贷数据表")
public class KmsSd120Entity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "kkber",value = "贷方控制范围")
    @Column(name = "kkber", nullable = false, length = 32,  columnDefinition = "varchar(32) COMMENT '贷方控制范围'")
    private String kkber;

    @ApiModelProperty(name = "kkbtx",value = "贷方控制范围描述")
    @Column(name = "kkbtx", nullable = false, length = 32,  columnDefinition = "varchar(32) COMMENT '贷方控制范围描述'")
    private String kkbtx;

    @ApiModelProperty(name = "kunnr",value = "客户编号")
    @Column(name = "kunnr", nullable = false, length = 32,  columnDefinition = "varchar(32) COMMENT '客户编号'")
    private String kunnr;

    @ApiModelProperty(name = "name1",value = "名称1")
    @Column(name = "name1", nullable = false, length = 32,  columnDefinition = "varchar(32) COMMENT '名称1'")
    private String name1;

    @ApiModelProperty(name = "knkli",value = "信贷帐户号")
    @Column(name = "knkli", nullable = false, length = 32,  columnDefinition = "varchar(32) COMMENT '信贷帐户号'")
    private String knkli;

    @ApiModelProperty(name = "klimk",value = "信贷限额")
    @Column(name = "klimk", nullable = false, columnDefinition = "decimal(15,2) COMMENT '信贷限额'")
    private BigDecimal klimk;

    @ApiModelProperty(name = "skfor",value = "应收总额")
    @Column(name = "skfor",  columnDefinition = "decimal(15,2) COMMENT '应收总额'")
    private BigDecimal skfor;

    @ApiModelProperty(name = "ssobl",value = "特别往来债务")
    @Column(name = "ssobl",  columnDefinition = "decimal(15,2) COMMENT '特别往来债务'")
    private BigDecimal ssobl;

    @ApiModelProperty(name = "ctlpc",value = "风险类别")
    @Column(name = "ctlpc",  nullable = false, columnDefinition = "varchar(3) COMMENT '风险类别'")
    private String ctlpc;

    @ApiModelProperty(name = "sauft",value = "销售值")
    @Column(name = "sauft",  columnDefinition = "decimal(15,2) COMMENT '销售值'")
    private BigDecimal sauft;

    @ApiModelProperty(name = "hedi01",value = "预留字段1")
    @Column(name = "hedi01",   columnDefinition = "varchar(32) COMMENT '预留字段1'")
    private String hedi01;

    @ApiModelProperty(name = "hedi02",value = "预留字段2")
    @Column(name = "hedi02",   columnDefinition = "varchar(32) COMMENT '预留字段2'")
    private String hedi02;

    @ApiModelProperty(name = "hedi03",value = "预留字段3")
    @Column(name = "hedi03",  columnDefinition = "varchar(32) COMMENT '预留字段3'")
    private String hedi03;

    @ApiModelProperty(name = "hedi04",value = "预留字段4")
    @Column(name = "hedi04",  columnDefinition = "varchar(32) COMMENT '预留字段4'")
    private String hedi04;

    @ApiModelProperty(name = "hedi05",value = "预留字段5")
    @Column(name = "hedi05",  columnDefinition = "varchar(32) COMMENT '预留字段5'")
    private String hedi05;
}
