package com.biz.crm.kms.business.statement.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;

@ApiModel(value = "SapExposureEntity", description = "KMS-敞口SAP")
@TableName("kms_exposure_sap")
@Getter
@Setter
@Entity(name = "kms_exposure_sap")
@Table(name = "kms_exposure_sap")
@org.hibernate.annotations.Table(appliesTo = "kms_exposure_sap", comment = "KMS-敞口SAP")
public class SapExposureEntity {

    @Id
    @ApiModelProperty(value = "id")
    @Column(name = "id", length = 255,  columnDefinition = "varchar(255) COMMENT 'id'")
    private String id;

    @ApiModelProperty(value = "售达方编码")
    @Column(name = "sell_party_code", length = 32,  columnDefinition = "varchar(32) COMMENT '售达方编码'")
    private String sellPartyCode;

    @ApiModelProperty(value = "售达方名称")
    @Column(name = "sell_party_name", length = 255,  columnDefinition = "varchar(255) COMMENT '售达方名称'")
    private String sellPartyName;

    @ApiModelProperty(value = "信贷范围")
    @Column(name = "credit_scope", length = 32,  columnDefinition = "varchar(32) COMMENT '信贷范围'")
    private String creditScope;

    @ApiModelProperty("信贷额度")
    @Column(name = "exposure_initial", columnDefinition = "Decimal(16,6) COMMENT '信贷额度'")
    private BigDecimal exposureInitial;

    @ApiModelProperty("销售值")
    @Column(name = "value_of_sale", columnDefinition = "Decimal(16,6) COMMENT '销售值'")
    private BigDecimal valueOfSale;

    @ApiModelProperty("应收总额")
    @Column(name = "receivable_total", columnDefinition = "Decimal(16,6) COMMENT '应收总额'")
    private BigDecimal receivableTotal;

    @ApiModelProperty("信贷风险总额")
    @Column(name = "credit_risk_total", columnDefinition = "Decimal(16,6) COMMENT '信贷风险总额'")
    private BigDecimal creditRiskTotal;

    @ApiModelProperty("剩余信贷额度")
    @Column(name = "sap_exposure_current", columnDefinition = "Decimal(16,6) COMMENT '剩余信贷额度'")
    private BigDecimal sapExposureCurrent;

    @ApiModelProperty("费用余额")
    @Column(name = "fee_pool_balence", columnDefinition = "Decimal(16,6) COMMENT '费用余额'")
    private BigDecimal feePoolBalence;

    @ApiModelProperty("待扣余额")
    @Column(name = "pend_balence", columnDefinition = "Decimal(16,6) COMMENT '待扣余额'")
    private BigDecimal pendBalence;

    @ApiModelProperty("冻结订单金额")
    @Column(name = "frozen_order_amount", columnDefinition = "Decimal(16,6) COMMENT '冻结订单金额'")
    private BigDecimal frozenOrderAmount;

    @ApiModelProperty("参考总余额")
    @Column(name = "reference_total_balance", columnDefinition = "Decimal(16,6) COMMENT '参考总余额'")
    private BigDecimal referenceTotalBalance;
}
