package com.biz.crm.kms.business.statement.local.exports.model;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;

/**
 * 敞口管理Vo
 */
@Data
public class ExposureExportsVo extends CrmExcelVo {

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @CrmExcelColumn(value = "业态")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @CrmExcelColumn(value = "业务单元")
    private String businessUnitCode;

    /**
     * 商超编码
     */
    private String supermarketCode;

    /**
     * 商超系统名称
     */
    @CrmExcelColumn(value = "商超系统名称")
    private String supermarketName;

    /**
     * 售达方编码
     */
    private String sellPartyCode;

    /**
     * 售达方名称
     */
    @CrmExcelColumn(value = "售达方名称")
    private String sellPartyName;

    /**
     * 是否使用敞口
     */
    @CrmExcelColumn(value = "是否使用敞口")
    private String isExposure;

    /**
     * 初始敞口额度
     */
    @CrmExcelColumn(value = "初始敞口额度")
    private String exposureInitial;

    /**
     * 当前敞口额度
     */
    @CrmExcelColumn(value = "当前敞口额度")
    private String exposureCurrent;
}
