package com.biz.crm.kms.business.statement.local.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.kms.business.statement.local.exports.mapper.ExposureExportsMapper;
import com.biz.crm.kms.business.statement.local.exports.model.ExposureExoprtsDto;
import com.biz.crm.kms.business.statement.local.exports.model.ExposureExportsVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
public class ExposureExportsProcess implements ExportProcess<ExposureExportsVo> {

    @Autowired
    private ExposureExportsMapper exposureExportsMapper;

    @Override
    public Integer getTotal(Map<String, Object> params) {
        ExposureExoprtsDto dto = this.convertParams(params);
        return exposureExportsMapper.getExportTotal(dto);
    }

    private ExposureExoprtsDto convertParams(Map<String, Object> params) {
        return JSON.parseObject(JSON.toJSONString(params), ExposureExoprtsDto.class);
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        params.remove("sort");
        params.remove("europaInfoCode");
        Map<String, Object> map = params.entrySet().stream()
                .collect(Collectors.toMap(e -> e.getKey().substring(0, e.getKey().lastIndexOf("_")), Map.Entry::getValue));
        ExposureExoprtsDto dto = this.convertParams(map);
        dto.setOffset(this.getPageSize() * vo.getPageNo());
        dto.setLimit(vo.getPageSize());
        List<ExposureExoprtsDto> data = exposureExportsMapper.findData(dto);
        return JSON.parseArray(JSON.toJSONString(data));
    }

    @Override
    public Class<ExposureExportsVo> findCrmExcelVoClass() {
        return ExposureExportsVo.class;
    }


    @Override
    public String getBusinessCode() {
        return "KMS_EXPOSURE_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "KMS敞口管理导出";
    }
}
