package com.biz.crm.kms.business.statement.local.repository;



import com.biz.crm.kms.business.statement.local.entity.ExposureEntity;
import com.biz.crm.kms.business.statement.sdk.vo.ExposureVo;
import com.biz.crm.kms.business.statement.local.mapper.ExposureVoMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;

import javax.annotation.Resource;
import java.util.List;

/**
 * 敞口管理Vo(ExposureVo)表数据库访问层
 *
 * @author zs
 * @since 2022-11-05 15:59:19
 */
@Component
public class ExposureVoRepository extends ServiceImpl<ExposureVoMapper, ExposureEntity> {

  @Resource
  private ExposureVoMapper exposureVoMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param exposureVo 实体对象
   * @return
   */
  public Page<ExposureVo> findByConditions(Pageable pageable, ExposureVo exposureVo) {
    Page<ExposureVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<ExposureVo> pageList = this.exposureVoMapper.findByConditions(page, exposureVo);
    return pageList;
  }
  
  /**
   * 根据id集合更新启禁用装填
   * @param ids 分页对象
   * @param enableStatus 启禁用状态对象
   * @return
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
            .in(ExposureEntity::getId, ids)
            .set(ExposureEntity::getEnableStatus, enableStatus.getCode())
            .update();
  }

  /**
   * 根据商超系统查找敞口信息
   * @param supermarketCode
   * @return
   */
  public List<ExposureEntity> findBySupermarket(String supermarketCode,String supermarketName){
    return this.lambdaQuery()
            .eq(StringUtils.isNotBlank(supermarketName),ExposureEntity::getSupermarketCode,supermarketCode)
            .eq(StringUtils.isNotBlank(supermarketName),ExposureEntity::getSupermarketName,supermarketName)
            .list();
  }
}

