package com.biz.crm.kms.business.statement.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.kms.business.statement.local.entity.KmsSd120Entity;
import com.biz.crm.kms.business.statement.local.mapper.KmsSd120Mapper;
import com.biz.crm.kms.business.statement.sdk.dto.KmsSd120Dto;
import com.biz.crm.kms.business.statement.sdk.vo.ExposureVo;
import com.biz.crm.kms.business.statement.sdk.vo.KmsSd120Vo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * KmsSd120表数据库访问层
 *
 * @author zs
 * @since 2022-11-05 15:59:19
 */
@Component
public class KmsSd120Repository extends ServiceImpl<KmsSd120Mapper, KmsSd120Entity> {

    /**
     * 分页查询数据
     * @param pageable 分页对象
     * @param kmsSd120Dto 实体对象
     * @return
     */
    public Page<KmsSd120Vo> findByConditions(Pageable pageable, KmsSd120Dto kmsSd120Dto) {
        Page<KmsSd120Vo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<KmsSd120Vo> pageList = this.baseMapper.findByConditions(page, kmsSd120Dto);
        return pageList;
    }

    /**
     * 清空数据
     */
    public void deleteAll(){
        this.lambdaUpdate().eq(KmsSd120Entity::getTenantCode, TenantUtils.getTenantCode()).remove();
    }
}

