package com.biz.crm.kms.business.statement.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.kms.business.statement.local.entity.SapExposureEntity;
import com.biz.crm.kms.business.statement.local.mapper.SapExposureMapper;
import com.biz.crm.kms.business.statement.sdk.vo.SapExposureVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 敞口SAP(SapExposureEntity)表数据库访问层
 */
@Component
public class SapExposureRepository extends ServiceImpl<SapExposureMapper, SapExposureEntity> {
    @Autowired(required = false)
    private SapExposureMapper sapExposureMapper;

    /**
     * 分页查询SAP数据
     *
     * @param count 偏移量
     * @param size  默认每页查询条数
     * @return
     */
    public List<SapExposureVo> selectByPage(Integer count, Integer size) {
        return sapExposureMapper.selectByPage(count, size);
    }
}

