package com.biz.crm.kms.business.statement.local.service.internal;

import com.biz.crm.kms.business.statement.local.entity.ExposureEntity;
import com.biz.crm.kms.business.statement.local.repository.ExposureVoRepository;
import com.biz.crm.kms.business.statement.local.service.ExposureTransService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service("exposureTransService")
public class ExposureTransServiceImpl implements ExposureTransService {
    @Autowired(required = false)
    private ExposureVoRepository exposureVoRepository;

    /**
     * 批量保存
     *
     * @param saveList
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveDataList(List<ExposureEntity> saveList) {
        exposureVoRepository.saveBatch(saveList);
    }
}