package com.biz.crm.kms.business.statement.local.service.internal;

import com.biz.crm.kms.business.statement.sdk.service.ExposureVoService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 稽核数据定时任务     job
 *
 * @author cyj
 * @version 1.0
 * @date 2023/1/10 16:00
 * @description AuditXxlJob
 */
@Slf4j
@Service
public class ExposureXxlJob {

    @Autowired(required = false)
    private ExposureVoService exposureVoService;

    /**
     * 信贷120获取数据接口
     */
    @DynamicTaskService(cornExpression = "0 0 0-12 * * ? ", taskDesc = "信贷120获取数据接口")
    public void autoExtractSap120() {
        //TODO  需要改成  定时任务分片+redis锁
        this.exposureVoService.updateSD();
    }

    /**
     * 定时生成更新敞口数据
     */
    @DynamicTaskService(cornExpression = "0 30 0/12 * * ? ", taskDesc = "定时生成更新敞口数据")
    public void autoSynchronize() {
        //TODO  需要改成  定时任务分片+redis锁
        this.exposureVoService.synchronize();
    }
}
