package com.biz.crm.kms.business.statement.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.statement.local.entity.KmsSd120Entity;
import com.biz.crm.kms.business.statement.local.repository.KmsSd120Repository;
import com.biz.crm.mn.third.system.sd.sdk.dto.LineOfCreditCallbackDataDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.LineOfCreditCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.service.LineOfCreditCallbackService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @Class LineOfCreditCallbackServiceImpl
 * @Description 回调接口实现
 * @Author : ZS
 * @Date: 2023/1/3  18:05
 */
@Slf4j
@Service
public class LineOfCreditCallbackServiceImpl implements LineOfCreditCallbackService {

    private static String ZERO = "0.00";

    @Autowired(required = false)
    private KmsSd120Repository kmsSd120Repository;

    private static String regEx="[^\\.0-9]";
    @Override
    public void LineOfCredit(LineOfCreditCallbackDto dto) {
        if (Objects.isNull(dto)) {
            return;
        }
        log.info("回调接口数据为，信息:{}", dto);
        if (!CollectionUtils.isEmpty(dto.getITEM1())) {
            List<LineOfCreditCallbackDataDto> item1 = dto.getITEM1();
            List<KmsSd120Entity> kmsSd120EntityList = this.copyItemToEntity(item1);
            this.kmsSd120Repository.saveBatch(kmsSd120EntityList);
        }
    }
    private List<KmsSd120Entity> copyItemToEntity(List<LineOfCreditCallbackDataDto> dtoList) {
        Pattern p = Pattern.compile(regEx);
        List<KmsSd120Entity> entityList = new ArrayList<>();
        dtoList.forEach(o -> {
            KmsSd120Entity entity = new KmsSd120Entity();
            entity.setKkber(o.getKkber());
            entity.setKkbtx(o.getKkbtx());
            entity.setKunnr(o.getKunnr());
            entity.setName1(o.getName1());
            entity.setKnkli(o.getKnkli());
            if (StringUtils.isNotEmpty(o.getSkfor())) {
                Matcher m = p.matcher(o.getSkfor());
                String amount = m.replaceAll("").trim();
                if (o.getSkfor().contains("-")){
                    entity.setSkfor(new BigDecimal(amount).negate());
                }else {
                    entity.setSkfor(new BigDecimal(amount));
                }
            } else {
                entity.setSkfor(BigDecimal.ZERO);
            }
            if (StringUtils.isNotEmpty(o.getKlimk())) {
                Matcher m = p.matcher(o.getKlimk());
                String amount = m.replaceAll("").trim();
                if (o.getKlimk().contains("-")){
                    entity.setKlimk(new BigDecimal(amount).negate());
                }else {
                    entity.setKlimk(new BigDecimal(amount));
                }
            } else {
                entity.setKlimk(BigDecimal.ZERO);
            }
            if (StringUtils.isNotEmpty(o.getSsobl())) {
                Matcher m = p.matcher(o.getSsobl());
                String amount = m.replaceAll("").trim();
                if (o.getSsobl().contains("-")){
                    entity.setSsobl(new BigDecimal(amount).negate());
                }else {
                    entity.setSsobl(new BigDecimal(amount));
                }
            } else {
                entity.setSsobl(BigDecimal.ZERO);
            }
            if (StringUtils.isNotEmpty(o.getSauft())) {
                Matcher m = p.matcher(o.getSauft());
                String amount = m.replaceAll("").trim();
                if (o.getSauft().contains("-")){
                    entity.setSauft(new BigDecimal(amount));
                }else {
                    entity.setSauft(new BigDecimal(amount));
                }
            } else {
                entity.setSauft(BigDecimal.ZERO);
            }
            entity.setCtlpc(o.getCtlpc());
            entity.setHedi01(o.getHedi01());
            entity.setHedi02(o.getHedi02());
            entity.setHedi03(o.getHedi03());
            entity.setHedi04(o.getHedi04());
            entity.setHedi05(o.getHedi05());
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setEnableStatus(DelFlagStatusEnum.NORMAL.getCode());
            entityList.add(entity);
        });
        return entityList;
    }
}
