package com.biz.crm.kms.business.statement.local.service.internal;

import com.biz.crm.kms.business.statement.local.repository.SapExposureRepository;
import com.biz.crm.kms.business.statement.sdk.service.SapExposureService;
import com.biz.crm.kms.business.statement.sdk.vo.SapExposureVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 敞口SAP(SapExposureEntity)表服务实现类
 */
@Service("sapExposureService")
public class SapExposureServiceImpl implements SapExposureService {
    @Autowired(required = false)
    private SapExposureRepository sapExposureRepository;

    /**
     * 分页查询SAP数据
     *
     * @param count 当前页
     * @param size 默认每页查询条数
     * @return
     */
    @Override
    public List<SapExposureVo> selectByPage(int count, Integer size) {
        count = count * size;
        return sapExposureRepository.selectByPage(count,size);
    }
}
