/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.statement.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.statement.sdk.service.ExposureVoService;
import com.biz.crm.kms.business.statement.sdk.vo.ExposureVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/exposureVo/exposureVo"})
@Api(tags={"\u655e\u53e3\u7ba1\u7406"})
public class ExposureVoController {
    private static final Logger log = LoggerFactory.getLogger(ExposureVoController.class);
    @Autowired
    private ExposureVoService exposureVoService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<ExposureVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="exposureVo", value="\u655e\u53e3\u7ba1\u7406Vo") ExposureVo exposureVo) {
        try {
            Page page = this.exposureVoService.findByConditions(pageable, exposureVo);
            return Result.ok((Object)page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<ExposureVo> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            ExposureVo exposureVo = this.exposureVoService.findById(id);
            return Result.ok((Object)exposureVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5546\u8d85\u7cfb\u7edf\u67e5\u627e\u655e\u53e3\u4fe1\u606f")
    @GetMapping(value={"findBySupermarket"})
    public Result<List<ExposureVo>> findBySupermarket(@RequestParam String supermarketCode, @RequestParam String supermarketName) {
        try {
            List voList = this.exposureVoService.findBySupermarket(supermarketCode, supermarketName);
            return Result.ok((Object)voList);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<ExposureVo> create(@ApiParam(name="exposureVo", value="\u655e\u53e3\u7ba1\u7406Vo") @RequestBody ExposureVo exposureVo) {
        try {
            ExposureVo result = this.exposureVoService.create(exposureVo);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<ExposureVo> update(@ApiParam(name="exposureVo", value="\u655e\u53e3\u7ba1\u7406Vo") @RequestBody ExposureVo exposureVo) {
        try {
            ExposureVo result = this.exposureVoService.update(exposureVo);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6570\u636e\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.exposureVoService.delete(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"enable"})
    @ApiOperation(value="\u542f\u7528\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> enable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.exposureVoService.enable(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"disable"})
    @ApiOperation(value="\u7981\u7528\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> disable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.exposureVoService.disable(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u540c\u6b65SAP\u6570\u636e")
    @PostMapping(value={"synchronize"})
    public Result<?> synchronize() {
        try {
            this.exposureVoService.synchronize();
            return Result.ok((String)"\u540c\u6b65\u6210\u529f\uff01");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fe1\u8d37\u53d1\u9001\u63a5\u53e3")
    @GetMapping(value={"toSD"})
    public void toSd() {
        this.exposureVoService.toSD();
    }

    @ApiOperation(value="\u5b9a\u65f6\u540c\u6b65SD120")
    @PostMapping(value={"synchronize120"})
    public Result<?> synchronize120() {
        try {
            this.exposureVoService.updateSD();
            return Result.ok((String)"\u540c\u6b65\u6210\u529f\uff01");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

