/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.statement.local.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.kms.business.statement.local.exports.mapper.ExposureExportsMapper;
import com.biz.crm.kms.business.statement.local.exports.model.ExposureExoprtsDto;
import com.biz.crm.kms.business.statement.local.exports.model.ExposureExportsVo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExposureExportsProcess
implements ExportProcess<ExposureExportsVo> {
    @Autowired
    private ExposureExportsMapper exposureExportsMapper;

    public Integer getTotal(Map<String, Object> params) {
        ExposureExoprtsDto dto = this.convertParams(params);
        return this.exposureExportsMapper.getExportTotal(dto);
    }

    private ExposureExoprtsDto convertParams(Map<String, Object> params) {
        return (ExposureExoprtsDto)JSON.parseObject((String)JSON.toJSONString(params), ExposureExoprtsDto.class);
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        params.remove("sort");
        params.remove("europaInfoCode");
        Map<String, Object> map = params.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).substring(0, ((String)e.getKey()).lastIndexOf("_")), Map.Entry::getValue));
        ExposureExoprtsDto dto = this.convertParams(map);
        dto.setOffset(this.getPageSize() * vo.getPageNo());
        dto.setLimit(vo.getPageSize());
        List<ExposureExoprtsDto> data = this.exposureExportsMapper.findData(dto);
        return JSON.parseArray((String)JSON.toJSONString(data));
    }

    public Class<ExposureExportsVo> findCrmExcelVoClass() {
        return ExposureExportsVo.class;
    }

    public String getBusinessCode() {
        return "KMS_EXPOSURE_EXPORT";
    }

    public String getBusinessName() {
        return "KMS\u655e\u53e3\u7ba1\u7406\u5bfc\u51fa";
    }
}

