/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.statement.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.kms.business.direct.sdk.service.DirectVoService;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.kms.business.direct.store.sdk.dto.DirectStoreConditionDto;
import com.biz.crm.kms.business.direct.store.sdk.service.DirectStoreVoService;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.ReconciliationDto;
import com.biz.crm.kms.business.reconciliation.manage.sdk.service.ReconciliationService;
import com.biz.crm.kms.business.reconciliation.manage.sdk.vo.ReconciliationVo;
import com.biz.crm.kms.business.statement.local.entity.ExposureEntity;
import com.biz.crm.kms.business.statement.local.repository.ExposureVoRepository;
import com.biz.crm.kms.business.statement.local.repository.KmsSd120Repository;
import com.biz.crm.kms.business.statement.local.service.ExposureTransService;
import com.biz.crm.kms.business.statement.sdk.constant.ExposureConstant;
import com.biz.crm.kms.business.statement.sdk.dto.KmsSd120Dto;
import com.biz.crm.kms.business.statement.sdk.service.ExposureVoService;
import com.biz.crm.kms.business.statement.sdk.service.SapExposureService;
import com.biz.crm.kms.business.statement.sdk.vo.ExposureVo;
import com.biz.crm.kms.business.statement.sdk.vo.KmsSd120Vo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.third.system.sd.sdk.dto.LineOfCreditDataDto;
import com.biz.crm.mn.third.system.sd.sdk.service.SapSdApiService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="exposureVoService")
public class ExposureVoServiceImpl
implements ExposureVoService {
    private static final Logger log = LoggerFactory.getLogger(ExposureVoServiceImpl.class);
    @Autowired(required=false)
    private ExposureVoRepository exposureVoRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SapExposureService sapExposureService;
    @Autowired(required=false)
    private ReconciliationService reconciliationService;
    @Autowired(required=false)
    private ExposureTransService exposureTransService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private SapSdApiService sapSdApiService;
    @Autowired(required=false)
    private DirectStoreVoService directStoreVoService;
    @Autowired(required=false)
    private DirectVoService directVoService;
    @Autowired(required=false)
    private KmsSd120Repository kmsSd120Repository;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public Page<ExposureVo> findByConditions(Pageable pageable, ExposureVo exposureVo) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(exposureVo)) {
            exposureVo = new ExposureVo();
        }
        return this.exposureVoRepository.findByConditions(pageable, exposureVo);
    }

    public List<ExposureVo> findBySupermarket(String supermarketCode, String supermarketName) {
        List<ExposureEntity> entityList = this.exposureVoRepository.findBySupermarket(supermarketCode, supermarketName);
        ArrayList<ExposureVo> voList = new ArrayList<ExposureVo>();
        entityList.forEach(aa -> {
            ExposureVo vo = (ExposureVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)aa, ExposureVo.class, HashSet.class, ArrayList.class, new String[0]);
            voList.add(vo);
        });
        return voList;
    }

    public ExposureVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ExposureEntity entity = (ExposureEntity)((Object)this.exposureVoRepository.getById((Serializable)((Object)id)));
        ExposureVo vo = (ExposureVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ExposureVo.class, HashSet.class, ArrayList.class, new String[0]);
        return vo;
    }

    @Transactional
    public ExposureVo create(ExposureVo exposureVo) {
        this.createValidate(exposureVo);
        ExposureEntity entity = (ExposureEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)exposureVo, ExposureEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setTenantCode(TenantUtils.getTenantCode());
        this.exposureVoRepository.saveOrUpdate((Object)entity);
        return exposureVo;
    }

    @Transactional
    public ExposureVo update(ExposureVo exposureVo) {
        this.updateValidate(exposureVo);
        ExposureEntity entity = (ExposureEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)exposureVo, ExposureEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.exposureVoRepository.saveOrUpdate((Object)entity);
        return exposureVo;
    }

    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.exposureVoRepository.removeByIds(idList);
    }

    @Transactional
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.exposureVoRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE);
    }

    @Transactional
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.exposureVoRepository.updateEnableStatusByIds(idList, EnableStatusEnum.DISABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronize() {
        boolean lock = true;
        String lockKey = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            PageRequest reconciliationPageable = PageRequest.of((int)1, (int)ExposureConstant.DEFAULT_SIZE);
            ArrayList reconciliationVoList = new ArrayList();
            ReconciliationDto reconciliationDto = new ReconciliationDto();
            Page reconciliationVoPage = this.reconciliationService.findByConditions((Pageable)reconciliationPageable, reconciliationDto);
            reconciliationVoList.addAll(reconciliationVoPage.getRecords());
            while (reconciliationVoPage.hasNext() && ExposureConstant.DEFAULT_SIZE >= reconciliationPageable.getPageNumber()) {
                reconciliationPageable = reconciliationPageable.next();
                reconciliationVoPage = this.reconciliationService.findByConditions((Pageable)reconciliationPageable, reconciliationDto);
                reconciliationVoList.addAll(reconciliationVoPage.getRecords());
            }
            Map<Object, Object> reconciliationMap = new HashMap();
            if (!CollectionUtils.isEmpty(reconciliationVoList)) {
                reconciliationMap = reconciliationVoList.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getSoldToPartyCode())).distinct().collect(Collectors.groupingBy(ReconciliationVo::getSoldToPartyCode));
            }
            KmsSd120Dto dto = new KmsSd120Dto();
            dto.setTenantCode(TenantUtils.getTenantCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(DelFlagStatusEnum.NORMAL.getCode());
            PageRequest sd120Pageable = PageRequest.of((int)1, (int)ExposureConstant.DEFAULT_SIZE);
            ArrayList sd120VoList = new ArrayList();
            Page<KmsSd120Vo> kmsSd120VoPage = this.kmsSd120Repository.findByConditions((Pageable)sd120Pageable, dto);
            if (CollectionUtils.isEmpty((Collection)kmsSd120VoPage.getRecords())) {
                return;
            }
            sd120VoList.addAll(kmsSd120VoPage.getRecords());
            while (kmsSd120VoPage.hasNext() && ExposureConstant.DEFAULT_SIZE >= sd120Pageable.getPageNumber()) {
                sd120Pageable = sd120Pageable.next();
                kmsSd120VoPage = this.kmsSd120Repository.findByConditions((Pageable)sd120Pageable, dto);
                sd120VoList.addAll(kmsSd120VoPage.getRecords());
            }
            Set sellPartCode = sd120VoList.stream().map(KmsSd120Vo::getKunnr).collect(Collectors.toSet());
            DirectStoreConditionDto storeConditionDto = new DirectStoreConditionDto();
            storeConditionDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            storeConditionDto.setEnableStatus(DelFlagStatusEnum.NORMAL.getCode());
            storeConditionDto.setSoldToPartyCodes(sellPartCode);
            List directStoreVoList = this.directStoreVoService.findByDirectStoreConditionDto(storeConditionDto);
            Map<Object, Object> directVoMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)directStoreVoList)) {
                directVoMap = this.buildDirectVoInfo(directStoreVoList);
            }
            if (!CollectionUtils.isEmpty(sd120VoList)) {
                ArrayList<ExposureEntity> exposureEntityList = new ArrayList<ExposureEntity>();
                for (KmsSd120Vo kmsSd120Vo : sd120VoList) {
                    List reconciliationVos;
                    DirectVo directVo;
                    ExposureEntity exposureEntity = new ExposureEntity();
                    exposureEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    exposureEntity.setEnableStatus(DelFlagStatusEnum.NORMAL.getCode());
                    exposureEntity.setTenantCode(TenantUtils.getTenantCode());
                    if (MapUtils.isNotEmpty(directVoMap) && Objects.nonNull(directVo = (DirectVo)directVoMap.get(kmsSd120Vo.getKunnr()))) {
                        exposureEntity.setDirectCode(directVo.getDirectCode());
                        exposureEntity.setDirectName(directVo.getSupermarketName());
                        exposureEntity.setSupermarketCode(directVo.getSupermarketCode());
                        exposureEntity.setSupermarketName(directVo.getSupermarketName());
                        exposureEntity.setBusinessFormatCode(directVo.getBusinessFormatCode());
                        exposureEntity.setBusinessUnitCode(directVo.getBusinessUnitCode());
                    }
                    if (!CollectionUtils.isEmpty((Collection)(reconciliationVos = (List)reconciliationMap.get(kmsSd120Vo.getKunnr())))) {
                        BigDecimal amountExposure = BigDecimal.ZERO;
                        for (ReconciliationVo reconciliationVo : reconciliationVos) {
                            amountExposure = amountExposure.add(reconciliationVo.getOccupiedExposure() == null ? BigDecimal.ZERO : reconciliationVo.getOccupiedExposure());
                        }
                        exposureEntity.setExposureCurrent(amountExposure);
                    } else {
                        exposureEntity.setExposureCurrent(BigDecimal.ZERO);
                    }
                    exposureEntity.setExposureInitial(kmsSd120Vo.getKlimk() == null ? BigDecimal.ZERO : kmsSd120Vo.getKlimk());
                    exposureEntity.setSalesAmount(kmsSd120Vo.getSauft());
                    exposureEntity.setSapExposureCurrent(exposureEntity.getExposureInitial().subtract(kmsSd120Vo.getSauft()).subtract(kmsSd120Vo.getSkfor()));
                    exposureEntity.setRemainingCreditLine(exposureEntity.getExposureInitial().subtract(exposureEntity.getExposureCurrent()).setScale(6, 1));
                    exposureEntity.setSellPartyCode(kmsSd120Vo.getKunnr());
                    exposureEntity.setSellPartyName(kmsSd120Vo.getName1());
                    exposureEntityList.add(exposureEntity);
                }
                PageRequest exposurePageable = PageRequest.of((int)1, (int)ExposureConstant.DEFAULT_SIZE);
                ArrayList exposureVoList = new ArrayList();
                ExposureVo exposureVo = new ExposureVo();
                exposureVo.setTenantCode(TenantUtils.getTenantCode());
                Page<ExposureVo> exposureVoPage = this.exposureVoRepository.findByConditions((Pageable)exposurePageable, exposureVo);
                exposureVoList.addAll(exposureVoPage.getRecords());
                while (exposureVoPage.hasNext() && ExposureConstant.DEFAULT_SIZE >= exposurePageable.getPageNumber()) {
                    exposurePageable = exposurePageable.next();
                    exposureVoPage = this.exposureVoRepository.findByConditions((Pageable)exposurePageable, exposureVo);
                    exposureVoList.addAll(exposureVoPage.getRecords());
                }
                Map<Object, Object> exposureVoMap = new HashMap();
                if (!CollectionUtils.isEmpty(exposureVoList)) {
                    exposureVoMap = exposureVoList.stream().collect(Collectors.toMap(ExposureVo::getSellPartyCode, UuidVo::getId, (a, b) -> a));
                }
                for (ExposureEntity exposureEntity : exposureEntityList) {
                    String id = (String)exposureVoMap.get(exposureEntity.getSellPartyCode());
                    if (!StringUtils.isEmpty((CharSequence)id)) continue;
                    exposureEntity.setId(id);
                }
                this.exposureVoRepository.saveOrUpdateBatch(exposureEntityList);
            }
        }
        finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    private void unLock(String lockKey) {
        if (StringUtils.isEmpty((CharSequence)lockKey)) {
            throw new RuntimeException("\u62c9\u53d6\u5e93\u5b58\u6570\u636e\u89e3\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.redisMutexService.unlock("exposure_report_lock:lock:" + lockKey);
    }

    private boolean lock(String lockKey) {
        if (StringUtils.isEmpty((CharSequence)lockKey)) {
            throw new RuntimeException("\u62c9\u53d6\u5e93\u5b58\u6570\u636e\u52a0\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.redisMutexService.tryLock("exposure_report_lock:lock:" + lockKey, TimeUnit.HOURS, 12);
    }

    public void toSD() {
        List salesCodes = this.dictDataVoService.findByDictTypeCode("kms_exposure_range");
        if (CollectionUtils.isEmpty((Collection)salesCodes)) {
            return;
        }
        Map<String, String> salesMap = salesCodes.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (a, b) -> a));
        LineOfCreditDataDto dto = new LineOfCreditDataDto();
        LineOfCreditDataDto.MessageHeader header = new LineOfCreditDataDto.MessageHeader();
        header.setMessageId(UuidCrmUtil.general());
        header.setInterFace("SI_TPM120_XDEDCX_ASYN_OUT");
        header.setSender("TPM");
        header.setSendTime(DateUtil.date_yyyyMMddHHmmss.format(new Date()));
        header.setReceiver("ECC");
        dto.setMessageHeader(header);
        List directVos = this.directVoService.findDirectCodesByBusinessUnitCode("DY00000009");
        if (CollectionUtils.isEmpty((Collection)directVos)) {
            return;
        }
        Map directVoMap = directVos.stream().collect(Collectors.toMap(DirectVo::getDirectCode, Function.identity(), (a, b) -> a));
        List directCodes = directVos.stream().map(DirectVo::getDirectCode).distinct().collect(Collectors.toList());
        List soldPartyCodeByDirectCodes = this.directStoreVoService.findSoldPartyCodeByDirectCodes(directCodes);
        if (!CollectionUtils.isEmpty((Collection)soldPartyCodeByDirectCodes)) {
            List<Object> item1s = new ArrayList();
            for (DirectStoreVo directStoreVo : soldPartyCodeByDirectCodes) {
                String salesCode;
                DirectVo directVo = (DirectVo)directVoMap.get(directStoreVo.getDirectCode());
                if (!Objects.nonNull(directVo)) continue;
                LineOfCreditDataDto.Item1 item1 = new LineOfCreditDataDto.Item1();
                if (StringUtils.isEmpty((CharSequence)directVo.getSalesOrgCode()) || StringUtils.isEmpty((CharSequence)directStoreVo.getSoldToPartyCode()) || StringUtils.isEmpty((CharSequence)(salesCode = salesMap.get(directVo.getSalesOrgCode())))) continue;
                item1.setKkber(salesCode);
                item1.setKunnr(directStoreVo.getSoldToPartyCode());
                item1s.add(item1);
            }
            item1s = item1s.stream().distinct().collect(Collectors.toList());
            dto.setItems(item1s);
            this.sapSdApiService.queryLineOfCredit(dto);
        }
    }

    public void updateSD() {
        this.kmsSd120Repository.deleteAll();
        this.toSD();
    }

    private void createValidate(ExposureVo exposureVo) {
        Validate.notNull((Object)exposureVo, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        exposureVo.setId(null);
    }

    private void updateValidate(ExposureVo exposureVo) {
        Validate.notNull((Object)exposureVo, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private Map<String, DirectVo> buildDirectVoInfo(List<DirectStoreVo> directStoreVoList) {
        if (CollectionUtils.isEmpty(directStoreVoList)) {
            return null;
        }
        Map<String, String> directStoreVoMap = directStoreVoList.stream().collect(Collectors.toMap(DirectStoreVo::getSoldToPartyCode, DirectStoreVo::getDirectCode, (a, b) -> a));
        List directCodes = directStoreVoList.stream().map(DirectStoreVo::getDirectCode).distinct().collect(Collectors.toList());
        List directVoList = this.directVoService.findByDirectCodes(directCodes);
        Map directVoMap = directVoList.stream().collect(Collectors.toMap(DirectVo::getDirectCode, Function.identity()));
        HashMap<String, DirectVo> resultDirectVoMap = new HashMap<String, DirectVo>();
        if (!CollectionUtils.isEmpty(directVoMap)) {
            for (String soldPartyCode : directStoreVoMap.keySet()) {
                if (!directVoMap.containsKey(directStoreVoMap.get(soldPartyCode))) continue;
                resultDirectVoMap.put(soldPartyCode, (DirectVo)directVoMap.get(directStoreVoMap.get(soldPartyCode)));
            }
        }
        return resultDirectVoMap;
    }
}

