package com.biz.crm.kms.business.statement.sdk.service;


import com.biz.crm.kms.business.statement.sdk.vo.ExposureVo;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 敞口管理Vo(ExposureVo)表服务接口
 *
 * @author makejava
 * @since 2022-11-05 15:59:19
 */
public interface ExposureVoService {

    /**
     * 分页查询数据
     *
     * @param pageable   分页对象
     * @param exposureVo 实体对象
     * @return
     */
    Page<ExposureVo> findByConditions(Pageable pageable, ExposureVo exposureVo);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    ExposureVo findById(String id);

    /**
     * 根据商超系统查找敞口信息
     *
     * @param supermarketCode
     * @return
     */
    List<ExposureVo> findBySupermarket(String supermarketCode, String supermarketName);

    /**
     * 新增数据
     *
     * @param exposureVo 实体对象
     * @return 新增结果
     */
    ExposureVo create(ExposureVo exposureVo);

    /**
     * 修改新据
     *
     * @param exposureVo 实体对象
     * @return 修改结果
     */
    ExposureVo update(ExposureVo exposureVo);

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    void delete(List<String> idList);

    /**
     * 启用（单个或者批量）
     *
     * @param idList 主键结合
     * @return 启用结果
     */
    void enable(List<String> idList);

    /**
     * 禁用（单个或者批量）
     *
     * @param idList 主键结合
     * @return 禁用结果
     */
    void disable(List<String> idList);

    /**
     * 同步SAP数据
     */
    void synchronize();

    /**
     * 信贷接口发送测试
     */
    void toSD();

    /**
     * 更新SD数据
     */
    void updateSD();
}

