package com.biz.crm.kms.business.statement.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 敞口管理Vo
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class ExposureVo extends TenantFlagOpVo {



    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty(name = "业务单元")
    private String businessUnitCode;

    /**
     * 零售商编码
     */
    @ApiModelProperty(value = "零售商编码")
    private String supermarketCode;

    /**
     * 商超系统名称
     */
    @ApiModelProperty(value = "商超系统名称")
    private String supermarketName;

    /**
     * 售达方编码
     */
    @ApiModelProperty(value = "售达方编码")
    private String sellPartyCode;

    /**
     * 售达方名称
     */
    @ApiModelProperty(value = "售达方名称")
    private String sellPartyName;

    /**
     * 初始敞口额度
     */
    @ApiModelProperty("信贷额度")
    private BigDecimal exposureInitial;

    /**
     * SAP剩余信贷额度
     */
    @ApiModelProperty("SAP剩余信贷额度")
    private BigDecimal sapExposureCurrent;
    /**
     * 已占用敞口额度
     */
    @ApiModelProperty("已占用敞口额度")
    private BigDecimal exposureCurrent;

    /**
     * 剩余信贷额度
     */
    @ApiModelProperty("剩余信贷额度")
    private BigDecimal remainingCreditLine;

    /**
     * 费用池余额
     */
    @ApiModelProperty("费用池余额")
    private BigDecimal feePoolBalence;
}
