package com.biz.crm.kms.business.statement.sdk.vo;


import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

@Data
public class SapExposureVo {
    @ApiModelProperty(value = "id")
    @Column(name = "id")
    private String id;

    @ApiModelProperty(value = "售达方编码")
    @Column(name = "sell_party_code")
    private String sellPartyCode;

    @ApiModelProperty(value = "售达方名称")
    @Column(name = "sell_party_name")
    private String sellPartyName;

    @ApiModelProperty(value = "信贷范围")
    @Column(name = "credit_scope")
    private String creditScope;

    @ApiModelProperty("信贷额度")
    @Column(name = "exposure_initial")
    private BigDecimal exposureInitial;

    @ApiModelProperty("销售值")
    @Column(name = "value_of_sale")
    private BigDecimal valueOfSale;

    @ApiModelProperty("应收总额")
    @Column(name = "receivable_total")
    private BigDecimal receivableTotal;

    @ApiModelProperty("信贷风险总额")
    @Column(name = "credit_risk_total")
    private BigDecimal creditRiskTotal;

    @ApiModelProperty("剩余信贷额度")
    @Column(name = "sap_exposure_current")
    private BigDecimal sapExposureCurrent;

    @ApiModelProperty("费用余额")
    @Column(name = "fee_pool_balence")
    private BigDecimal feePoolBalence;

    @ApiModelProperty("待扣余额")
    @Column(name = "pend_balence")
    private BigDecimal pendBalence;

    @ApiModelProperty("冻结订单金额")
    @Column(name = "frozen_order_amount")
    private BigDecimal frozenOrderAmount;

    @ApiModelProperty("参考总余额")
    @Column(name = "reference_total_balance")
    private BigDecimal referenceTotalBalance;
}
