/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.supermarket.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.supermarket.local.entity.Supermarket;
import com.biz.crm.kms.business.supermarket.local.service.SupermarketService;
import com.biz.crm.kms.business.supermarket.sdk.dto.SupermarketDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/supermarket/supermarket"})
@Api(tags={"\u5546\u8d85\u7ba1\u7406\uff1aSupermarket\uff1a\u5546\u8d85\u7ba1\u7406"})
public class SupermarketController {
    private static final Logger log = LoggerFactory.getLogger(SupermarketController.class);
    @Autowired
    private SupermarketService supermarketService;

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<Supermarket> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            Supermarket supermarket = this.supermarketService.findById(id);
            return Result.ok((Object)((Object)supermarket));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<Supermarket> create(@ApiParam(name="supermarket", value="\u5546\u8d85\u7ba1\u7406\u8868") @RequestBody Supermarket supermarket) {
        try {
            Supermarket result = this.supermarketService.create(supermarket);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<Supermarket> update(@ApiParam(name="supermarket", value="\u5546\u8d85\u7ba1\u7406\u8868") @RequestBody Supermarket supermarket) {
        try {
            Supermarket result = this.supermarketService.update(supermarket);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6570\u636e\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.supermarketService.delete(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"enable"})
    @ApiOperation(value="\u542f\u7528\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> enable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.supermarketService.enable(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"disable"})
    @ApiOperation(value="\u7981\u7528\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> disable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.supermarketService.disable(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u67e5\u8be2\u5546\u8d85\u6570\u636e")
    @GetMapping(value={"findBySupermarketDto"})
    public Result<List<Supermarket>> findBySupermarketDto(@ApiParam(name="dto", value="dto") SupermarketDto dto) {
        try {
            List<Supermarket> supermarket = this.supermarketService.findBySupermarketDto(dto);
            return Result.ok(supermarket);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

