/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.supermarket.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.supermarket.local.entity.Supermarket;
import com.biz.crm.kms.business.supermarket.local.mapper.SupermarketMapper;
import com.biz.crm.kms.business.supermarket.sdk.dto.SupermarketDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class SupermarketRepository
extends ServiceImpl<SupermarketMapper, Supermarket> {
    public Supermarket findBySupermarketName(String supermarketName) {
        return (Supermarket)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Supermarket::getSupermarketName, (Object)supermarketName)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public List<Supermarket> findBySupermarketCodes(Set<String> supermarketCodes, String tenantCode) {
        return ((SupermarketMapper)this.baseMapper).findBySupermarketCodes(supermarketCodes, tenantCode);
    }

    public List<Supermarket> findBySupermarketNames(Set<String> supermarketNames, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(Supermarket::getSupermarketName, supermarketNames)).list();
    }

    public List<Supermarket> findBySupermarketDto(SupermarketDto dto) {
        return ((SupermarketMapper)this.baseMapper).findBySupermarketDto(dto);
    }

    public List<Supermarket> findByIds(List<String> idList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, idList)).list();
    }

    public List<Supermarket> findEnableStatusByIds(EnableStatusEnum statusEnum, List<String> idList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)statusEnum.getCode())).in(UuidEntity::getId, idList)).list();
    }
}

