/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.supermarket.local.service.internal;

import com.biz.crm.kms.business.supermarket.local.entity.SupermarketArea;
import com.biz.crm.kms.business.supermarket.local.repository.SupermarketAreaRepository;
import com.biz.crm.kms.business.supermarket.local.service.SupermarketAreaService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="supermarketAreaService")
public class SupermarketAreaServiceImpl
implements SupermarketAreaService {
    @Autowired
    private SupermarketAreaRepository supermarketAreaRepository;

    @Override
    @Transactional
    public void createBatch(List<SupermarketArea> supermarketAreas) {
        Validate.isTrue((!CollectionUtils.isEmpty(supermarketAreas) ? 1 : 0) != 0, (String)"\u6279\u91cf\u65b0\u589e\u533a\u57df\u6570\u636e\u65f6\uff0c\u5165\u53c2\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((supermarketAreas.stream().map(SupermarketArea::getAreaCode).collect(Collectors.toSet()).size() == supermarketAreas.size() ? 1 : 0) != 0, (String)"\u6279\u91cf\u65b0\u589e\u533a\u57df\u6570\u636e\u65f6,\u5b58\u5728\u91cd\u590d\u7684\u533a\u57df\u7f16\u7801\uff01", (Object[])new Object[0]);
        supermarketAreas.forEach(this::createValidate);
        this.supermarketAreaRepository.saveBatch(supermarketAreas);
    }

    @Override
    @Transactional
    public void deleteBySupermarketCodes(List<String> supermarketCodes) {
        Validate.isTrue((!CollectionUtils.isEmpty(supermarketCodes) ? 1 : 0) != 0, (String)"\u6279\u91cf\u5220\u9664\u6570\u636e\u65f6\uff0c\u5546\u8d85\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.supermarketAreaRepository.deleteBySupermarketCodes(supermarketCodes);
    }

    @Override
    public List<SupermarketArea> findBySupermarketCodes(List<String> supermarketCodes) {
        if (CollectionUtils.isEmpty(supermarketCodes)) {
            return new ArrayList<SupermarketArea>(0);
        }
        return this.supermarketAreaRepository.findBySupermarketCodes(supermarketCodes);
    }

    private void createValidate(SupermarketArea supermarketArea) {
        Validate.notNull((Object)((Object)supermarketArea), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        supermarketArea.setId(null);
        Validate.notBlank((CharSequence)supermarketArea.getAreaCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)supermarketArea.getAreaName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u533a\u57df\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)supermarketArea.getSupermarketCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5546\u8d85\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

