/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.supermarket.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.kms.business.supermarket.local.entity.Supermarket;
import com.biz.crm.kms.business.supermarket.local.entity.SupermarketArea;
import com.biz.crm.kms.business.supermarket.local.repository.SupermarketRepository;
import com.biz.crm.kms.business.supermarket.local.service.SupermarketAreaService;
import com.biz.crm.kms.business.supermarket.local.service.SupermarketService;
import com.biz.crm.kms.business.supermarket.sdk.dto.SupermarketDto;
import com.biz.crm.kms.business.supermarket.sdk.listener.SupermarketOperationListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="supermarketService")
public class SupermarketServiceImpl
implements SupermarketService {
    @Autowired
    private SupermarketRepository supermarketRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private SupermarketAreaService supermarketAreaService;
    @Autowired(required=false)
    private List<SupermarketOperationListener> supermarketOperationListeners;

    @Override
    public Supermarket findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Supermarket supermarket = (Supermarket)((Object)this.supermarketRepository.getById((Serializable)((Object)id)));
        if (supermarket == null) {
            return null;
        }
        List<SupermarketArea> supermarketAreas = this.supermarketAreaService.findBySupermarketCodes(Lists.newArrayList((Object[])new String[]{supermarket.getSupermarketCode()}));
        supermarket.setSupermarketAreas(supermarketAreas);
        return supermarket;
    }

    @Override
    @Transactional
    public Supermarket create(Supermarket supermarket) {
        this.createValidate(supermarket);
        this.supermarketRepository.saveOrUpdate((Object)supermarket);
        List<SupermarketArea> supermarketAreas = supermarket.getSupermarketAreas();
        if (!CollectionUtils.isEmpty(supermarketAreas)) {
            supermarketAreas.stream().forEach(supermarketArea -> supermarketArea.setSupermarketCode(supermarket.getSupermarketCode()));
            this.supermarketAreaService.createBatch(supermarketAreas);
        }
        return supermarket;
    }

    @Override
    @Transactional
    public Supermarket update(Supermarket supermarket) {
        Validate.notBlank((CharSequence)supermarket.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Supermarket current = (Supermarket)((Object)this.supermarketRepository.getById((Serializable)((Object)supermarket.getId())));
        Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u8981\u4fee\u6539\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        BeanUtils.copyProperties((Object)((Object)supermarket), (Object)((Object)current), (String[])new String[]{"id", "supermarketCode", "tenantCode", "delFlag", "enableStatus", "createAccount", "createName", "createTime", "createName"});
        this.updateValidate(current);
        this.supermarketRepository.saveOrUpdate((Object)current);
        this.supermarketAreaService.deleteBySupermarketCodes(Lists.newArrayList((Object[])new String[]{current.getSupermarketCode()}));
        List<SupermarketArea> supermarketAreas = supermarket.getSupermarketAreas();
        if (!CollectionUtils.isEmpty(supermarketAreas)) {
            supermarketAreas.stream().forEach(supermarketArea -> supermarketArea.setSupermarketCode(current.getSupermarketCode()));
            this.supermarketAreaService.createBatch(supermarketAreas);
        }
        return current;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<Supermarket> supermarkets = this.supermarketRepository.findByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty(supermarkets) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u5220\u9664\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        supermarkets.stream().forEach(supermarket -> supermarket.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
        this.supermarketRepository.saveOrUpdateBatch(supermarkets);
        if (!CollectionUtils.isEmpty(this.supermarketOperationListeners)) {
            List supermarketCodes = supermarkets.stream().map(Supermarket::getSupermarketCode).collect(Collectors.toList());
            for (SupermarketOperationListener supermarketOperationListener : this.supermarketOperationListeners) {
                supermarketOperationListener.onDelete(supermarketCodes);
            }
        }
    }

    @Override
    @Transactional
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<Supermarket> supermarkets = this.supermarketRepository.findEnableStatusByIds(EnableStatusEnum.DISABLE, idList);
        Validate.isTrue((!CollectionUtils.isEmpty(supermarkets) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u542f\u7528\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        supermarkets.stream().forEach(supermarket -> supermarket.setEnableStatus(EnableStatusEnum.ENABLE.getCode()));
        this.supermarketRepository.saveOrUpdateBatch(supermarkets);
        if (!CollectionUtils.isEmpty(this.supermarketOperationListeners)) {
            List supermarketCodes = supermarkets.stream().map(Supermarket::getSupermarketCode).collect(Collectors.toList());
            for (SupermarketOperationListener supermarketOperationListener : this.supermarketOperationListeners) {
                supermarketOperationListener.onEnable(supermarketCodes);
            }
        }
    }

    @Override
    @Transactional
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<Supermarket> supermarkets = this.supermarketRepository.findEnableStatusByIds(EnableStatusEnum.ENABLE, idList);
        Validate.isTrue((!CollectionUtils.isEmpty(supermarkets) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u7981\u7528\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        supermarkets.stream().forEach(supermarket -> supermarket.setEnableStatus(EnableStatusEnum.DISABLE.getCode()));
        this.supermarketRepository.saveOrUpdateBatch(supermarkets);
        if (!CollectionUtils.isEmpty(this.supermarketOperationListeners)) {
            List supermarketCodes = supermarkets.stream().map(Supermarket::getSupermarketCode).collect(Collectors.toList());
            for (SupermarketOperationListener supermarketOperationListener : this.supermarketOperationListeners) {
                supermarketOperationListener.onDisable(supermarketCodes);
            }
        }
    }

    @Override
    public List<Supermarket> findBySupermarketDto(SupermarketDto dto) {
        if (dto == null) {
            dto = new SupermarketDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        return this.supermarketRepository.findBySupermarketDto(dto);
    }

    private void createValidate(Supermarket supermarket) {
        Validate.notNull((Object)((Object)supermarket), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        supermarket.setId(null);
        supermarket.setTenantCode(TenantUtils.getTenantCode());
        supermarket.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        supermarket.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        supermarket.setSupermarketCode((String)this.generateCodeService.generateCode("SC", 1).get(0));
        Validate.notBlank((CharSequence)supermarket.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)supermarket.getInvoiceType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)supermarket.getSupermarketCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5546\u8d85\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)supermarket.getSupermarketName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7cfb\u7edf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)supermarket.getSupermarketUrl(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7cfb\u7edf\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Supermarket bySuperMarketName = this.supermarketRepository.findBySupermarketName(supermarket.getSupermarketName());
        Validate.isTrue((bySuperMarketName == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5546\u8d85\u7cfb\u7edf\u540d\u79f0\u91cd\u590d\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(Supermarket supermarket) {
        Validate.notNull((Object)((Object)supermarket), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)supermarket.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)supermarket.getInvoiceType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)supermarket.getSupermarketCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5546\u8d85\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)supermarket.getSupermarketName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u7cfb\u7edf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)supermarket.getSupermarketUrl(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u7cfb\u7edf\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Supermarket bySuperMarketName = this.supermarketRepository.findBySupermarketName(supermarket.getSupermarketName());
        Validate.isTrue((bySuperMarketName == null || bySuperMarketName.getId().equals(supermarket.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5546\u8d85\u7cfb\u7edf\u540d\u79f0\u91cd\u590d\uff01", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)supermarket.getCustomerRetailerCode())) {
            supermarket.setCustomerRetailerName("");
        }
    }
}

