/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.supermarket.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.supermarket.local.entity.Supermarket;
import com.biz.crm.kms.business.supermarket.local.repository.SupermarketRepository;
import com.biz.crm.kms.business.supermarket.sdk.service.SupermarketVoService;
import com.biz.crm.kms.business.supermarket.sdk.vo.SupermarketVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SupermarketVoServiceImpl
implements SupermarketVoService {
    @Autowired
    private SupermarketRepository supermarketRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<SupermarketVo> findBySupermarketCodes(Set<String> supermarketCodes) {
        if (CollectionUtils.isEmpty(supermarketCodes)) {
            return Lists.newLinkedList();
        }
        List<Supermarket> supermarkets = this.supermarketRepository.findBySupermarketCodes(supermarketCodes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(supermarkets)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(supermarkets, Supermarket.class, SupermarketVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<SupermarketVo> findBySupermaketNames(Set<String> supermarketNames) {
        if (CollectionUtils.isEmpty(supermarketNames)) {
            return Lists.newLinkedList();
        }
        List<Supermarket> supermarkets = this.supermarketRepository.findBySupermarketNames(supermarketNames, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(supermarkets)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(supermarkets, Supermarket.class, SupermarketVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<SupermarketVo> findAllSupermarket() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode());
        List supermarkets = this.supermarketRepository.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)supermarkets)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)supermarkets, Supermarket.class, SupermarketVo.class, HashSet.class, ArrayList.class, new String[0]);
    }
}

