package com.biz.crm.kms.business.supermarket.parameter.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.supermarket.parameter.sdk.dto.SupermarketParameterGrabModeDto;
import com.biz.crm.kms.business.supermarket.parameter.sdk.service.SupermarketParameterGrabModeVoService;
import com.biz.crm.kms.business.supermarket.parameter.sdk.vo.SupermarketParameterGrabModeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collections;
import java.util.List;

/**
 * 商超抓单参数抓单方式表(SupermarketParameterGrabMode)表控制层
 *
 * @author xi.peng
 * @since 2022-09-23 10:47:58
 */
@Slf4j
@Api(tags = "商超抓单参数抓单方式：SupermarketParameterGrabModeVo：商超抓单参数抓单方式")
@RestController
@RequestMapping(value = {"/v1/supermarketParameter/supermarketParameterGrabModeVo"})
public class SupermarketParameterGrabModeVoController {

  @Autowired(required = false)
  private SupermarketParameterGrabModeVoService supermarketParameterGrabModeVoService;

  @ApiOperation(value = "按商超编码查询抓单方式列表")
  @GetMapping(value = {"/findBySupermarketCode"})
  public Result<List<SupermarketParameterGrabModeVo>> findBySupermarketCode(String supermarketCode,String orderType) {
    try {
      List<SupermarketParameterGrabModeVo> result = this.supermarketParameterGrabModeVoService.findBySupermarketCodes(Collections.singletonList(supermarketCode),orderType);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "批量创建")
  @PostMapping(value = "createBatch")
  public Result createBatch(@RequestBody List<SupermarketParameterGrabModeDto> dtoList) {
    try {
      this.supermarketParameterGrabModeVoService.createBatch(dtoList);
      return Result.ok("创建成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
