package com.biz.crm.kms.business.supermarket.parameter.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 商超抓单参数表抓单方式表(SupermarketParameterGrabMode)实体类
 *
 * @author pengxi
 * @since 2022-09-23 10:49:14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(name = "kms_supermarket_parameter_grab_mode")
@TableName(value = "kms_supermarket_parameter_grab_mode")
@ApiModel(value = "SupermarketParameterGrabMode", description = "商超抓单参数表抓单方式表")
@org.hibernate.annotations.Table(appliesTo = "kms_supermarket_parameter_grab_mode", comment = "商超抓单参数表抓单方式表")
public class SupermarketParameterGrabModeEntity extends TenantEntity {

  @ApiModelProperty("商超编码")
  @TableField(value = "supermarket_code")
  @Column(name = "supermarket_code", length = 32, columnDefinition = "varchar(32) COMMENT '商超编码'")
  private String supermarketCode;

  @ApiModelProperty("单据类型")
  @TableField(value = "order_type")
  @Column(name = "order_type", length = 32, columnDefinition = "varchar(32) COMMENT '接口参数'")
  private String orderType;

  @ApiModelProperty("下载方式（0：单线程，1：多线程）")
  @TableField(value = "download_type")
  @Column(name = "download_type", length = 32, columnDefinition = "varchar(32) COMMENT '下载方式（0：单线程，1：多线程）'")
  private String downloadType;
}
