package com.biz.crm.kms.business.supermarket.parameter.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.supermarket.parameter.local.entity.SupermarketParameterEntity;
import com.biz.crm.kms.business.supermarket.parameter.sdk.dto.SupermarketParameterDto;
import com.biz.crm.kms.business.supermarket.parameter.sdk.dto.SupermarketParameterPageDto;
import com.biz.crm.kms.business.supermarket.parameter.sdk.vo.SupermarketParameterVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 商超抓单参数表(SupermarketParameter)表数据库访问层
 *
 * @author xi.peng
 * @since 2022-09-23 10:47:57
 */
public interface SupermarketParameterMapper extends BaseMapper<SupermarketParameterEntity> {

  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<SupermarketParameterVo> findByConditions(Page<SupermarketParameterPageDto> page, @Param("dto") SupermarketParameterPageDto dto);

  /**
   * 条件查询
   *
   * @param dto  分页参数dto
   * @return 分页列表
   */
  List<SupermarketParameterVo> findByConditions(@Param("dto") SupermarketParameterDto dto);

}

