package com.biz.crm.kms.business.supermarket.parameter.local.service.internal;

import com.biz.crm.kms.business.invoice.sdk.constant.InvoiceConstant;
import com.biz.crm.kms.business.invoice.sdk.service.InvoiceTypeService;
import com.biz.crm.kms.business.invoice.sdk.vo.InvoiceTypeVo;
import com.biz.crm.kms.business.supermarket.parameter.local.entity.SupermarketParameterGrabModeEntity;
import com.biz.crm.kms.business.supermarket.parameter.local.repository.SupermarketParameterGrabModeRepository;
import com.biz.crm.kms.business.supermarket.parameter.sdk.dto.SupermarketParameterGrabModeDto;
import com.biz.crm.kms.business.supermarket.parameter.sdk.service.SupermarketParameterGrabModeVoService;
import com.biz.crm.kms.business.supermarket.parameter.sdk.vo.SupermarketParameterGrabModeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 商超抓单参数表抓单方式表(SupermarketParameterGrabMode)表服务实现类
 *
 * @author xi.peng
 * @since 2022-09-23 10:49:15
 */
@Slf4j
@Service
public class SupermarketParameterGrabModeVoServiceImpl implements SupermarketParameterGrabModeVoService {

  @Autowired(required = false)
  private SupermarketParameterGrabModeRepository supermarketParameterGrabModeRepository;

  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private InvoiceTypeService invoiceTypeService;

  @Override
  public SupermarketParameterGrabModeVo findDetailById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    SupermarketParameterGrabModeEntity entity = this.supermarketParameterGrabModeRepository.findById(id);
    if (entity == null) {
      return null;
    }
    return this.nebulaToolkitService.copyObjectByWhiteList(entity, SupermarketParameterGrabModeVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  public List<SupermarketParameterGrabModeVo> findBySupermarketCodes(List<String> parameterIds,String orderType) {
    if (CollectionUtils.isEmpty(parameterIds)) {
      return null;
    }
    List<SupermarketParameterGrabModeEntity> entities = this.supermarketParameterGrabModeRepository.findBySupermarketCodes(TenantUtils.getTenantCode(),orderType, parameterIds);
    if (CollectionUtils.isEmpty(entities)) {
      return null;
    }
    List<InvoiceTypeVo> invoiceTypeVos = this.invoiceTypeService.findAll();
    Map<String, String> map = new HashMap<>();
    if (!CollectionUtils.isEmpty(invoiceTypeVos)) {
      map = invoiceTypeVos.stream().collect(Collectors.toMap(InvoiceTypeVo::getType, InvoiceTypeVo::getName));
    }
    map.put(InvoiceConstant.LOGIN_ORDER_TYPE, InvoiceConstant.LOGIN_ORDER_NAME);
    List<SupermarketParameterGrabModeVo> lists = new ArrayList<>();
    for (SupermarketParameterGrabModeEntity entity : entities) {
      SupermarketParameterGrabModeVo vo = this.nebulaToolkitService.copyObjectByWhiteList(entity, SupermarketParameterGrabModeVo.class, HashSet.class, ArrayList.class);
      vo.setOrderName(map.get(vo.getOrderType()));
      lists.add(vo);
    }
    return lists;
  }

  @Override
  @Transactional
  public void createBatch(List<SupermarketParameterGrabModeDto> dtoList) {
    this.validation(dtoList);
    // 根据商超编码删除原数据
    String supermarketCode = dtoList.get(0).getSupermarketCode();
    this.deleteBySupermarketCode(supermarketCode);
    // 批量新增（保留原ID，若有）
    List<SupermarketParameterGrabModeEntity> entities = (List<SupermarketParameterGrabModeEntity>) this.nebulaToolkitService.copyCollectionByWhiteList(dtoList, SupermarketParameterGrabModeDto.class,
        SupermarketParameterGrabModeEntity.class, HashSet.class, ArrayList.class);
    this.supermarketParameterGrabModeRepository.saveBatch(entities);
  }

  @Override
  @Transactional
  public void deleteBySupermarketCode(String supermarketCode) {
    Validate.notBlank(supermarketCode, "商超编码不能为空！");
    List<SupermarketParameterGrabModeEntity> entities = this.supermarketParameterGrabModeRepository.findBySupermarketCode(TenantUtils.getTenantCode(), supermarketCode);
    if (CollectionUtils.isEmpty(entities)) {
      // 如果已删除或不存在就不继续向下执行
      return;
    }
    this.supermarketParameterGrabModeRepository.deleteBySupermarketCode(supermarketCode);
  }

  private void validation(List<SupermarketParameterGrabModeDto> dtoList) {
    Validate.notEmpty(dtoList, "选项集合对象不能为空！");
    String tenantCode = TenantUtils.getTenantCode();
    dtoList.forEach(dto -> {
      dto.setTenantCode(tenantCode);
      Validate.notBlank(dto.getSupermarketCode(), "商超编码不能为空！");
      Validate.notBlank(dto.getOrderType(), "单据类型不能为空！");
      Validate.notBlank(dto.getDownloadType(), "下载方式不能为空！");
    });
  }

}
