package com.biz.crm.kms.business.supermarket.parameter.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.bizunited.nebula.common.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 商超抓单参数表抓单方式表dto
 *
 * @author xi.peng
 * @since 2022-09-23 10:47:07
 */
@Data
@ApiModel(value = "SupermarketParameterGrabModeDto", description = "商超抓单参数表抓单方式表dto")
public class SupermarketParameterGrabModeDto extends TenantDto {

  /**
   * 商超编码
   */
  @ApiModelProperty("商超编码")
  private String supermarketCode;

  /**
   * 单据类型
   */
  @ApiModelProperty("单据类型")
  private String orderType;

  /**
   * 下载方式（0：单线程，1：多线程）
   */
  @ApiModelProperty("下载方式（0：单线程，1：多线程）")
  private String downloadType;
}

