package com.biz.crm.kms.business.supermarket.parameter.sdk.event;

import com.biz.crm.kms.business.supermarket.parameter.sdk.vo.SupermarketParameterVo;

import java.util.List;

/**
 * 商超抓单参数表变更事件通知接口
 *
 * @author xi.peng
 * @since 2022-09-23 10:45:21
 */
public interface SupermarketParameterEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(SupermarketParameterVo vo) {

  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(SupermarketParameterVo oldVo, SupermarketParameterVo newVo) {

  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<SupermarketParameterVo> list) {

  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<SupermarketParameterVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<SupermarketParameterVo> list) {

  }
}

