package com.biz.crm.kms.business.supermarket.parameter.sdk.event;

import com.biz.crm.kms.business.supermarket.parameter.sdk.vo.SupermarketParameterLabelVo;

import java.util.List;

/**
 * 商超抓单参数表附属标签表变更事件通知接口
 *
 * @author xi.peng
 * @since 2022-09-23 10:47:08
 */
public interface SupermarketParameterLabelEventListener {

  /**
   * 批量创建时触发
   *
   * @param voList
   */
  default void onCreateBatch(List<SupermarketParameterLabelVo> voList) {

  }

  /**
   * 根据parameterId删除时触发
   *
   * @param parameterId 接口参数ID
   */
  default void onDeleteByParameterId(String parameterId) {

  }
}

