package com.biz.crm.kms.business.supermarket.parameter.sdk.service;

import com.biz.crm.kms.business.supermarket.parameter.sdk.dto.SupermarketParameterGrabModeDto;
import com.biz.crm.kms.business.supermarket.parameter.sdk.vo.SupermarketParameterGrabModeVo;

import java.util.List;

/**
 * 商超抓单参数表抓单方式表(SupermarketParameterGrabMode)表服务接口
 *
 * @author xi.peng
 * @since 2022-09-23 10:47:07
 */
public interface SupermarketParameterGrabModeVoService {

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  SupermarketParameterGrabModeVo findDetailById(String id);

  /**
   * 按商超编码集合查询抓单方式列表
   *
   * @param supermarketCodes 商超编码集合
   * @return SupermarketParameterGrabModeVo
   */
  List<SupermarketParameterGrabModeVo> findBySupermarketCodes(List<String> supermarketCodes,String orderType);

  /**
   * 批量创建
   *
   * @param dtoList
   */
  void createBatch(List<SupermarketParameterGrabModeDto> dtoList);

  /**
   * 根据supermarketCode删除
   *
   * @param supermarketCode
   */
  void deleteBySupermarketCode(String supermarketCode);
}
