package com.biz.crm.kms.business.supermarket.parameter.sdk.service;

import com.biz.crm.kms.business.supermarket.parameter.sdk.dto.SupermarketParameterLabelDto;
import com.biz.crm.kms.business.supermarket.parameter.sdk.vo.SupermarketParameterLabelVo;

import java.util.List;

/**
 * 商超抓单参数表附属标签表(SupermarketParameterLabel)表服务接口
 *
 * @author xi.peng
 * @since 2022-09-23 10:47:08
 */
public interface SupermarketParameterLabelVoService {

  /**
   * 按id查询详情
   *
   * @param id ID主键
   * @return SupermarketParameterLabelVo
   */
  SupermarketParameterLabelVo findDetailById(String id);

  /**
   * 按parameterId查询选项列表
   *
   * @param parameterIds 接口参数ID集合
   * @return SupermarketParameterLabelVo
   */
  List<SupermarketParameterLabelVo> findParameterIds(List<String> parameterIds);

  /**
   * 批量创建
   *
   * @param dtoList
   */
  void createBatch(List<SupermarketParameterLabelDto> dtoList);

  /**
   * 根据parameterId删除
   *
   * @param parameterId
   */
  void deleteByParameterId(String parameterId);
}
