package com.biz.crm.kms.business.supermarket.parameter.sdk.service;

import com.biz.crm.kms.business.supermarket.parameter.sdk.dto.SupermarketParameterOptionDto;
import com.biz.crm.kms.business.supermarket.parameter.sdk.vo.SupermarketParameterOptionVo;

import java.util.List;

/**
 * 商超抓单参数表附属选项表(SupermarketParameterOption)表服务接口
 *
 * @author xi.peng
 * @since 2022-09-23 10:47:07
 */
public interface SupermarketParameterOptionVoService {

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  SupermarketParameterOptionVo findDetailById(String id);

  /**
   * 按parameterId集合查询选项列表
   *
   * @param parameterIds 接口参数ID集合
   * @return SupermarketParameterOptionVo
   */
  List<SupermarketParameterOptionVo> findParameterIds(List<String> parameterIds);

  /**
   * 批量创建
   *
   * @param dtoList
   */
  void createBatch(List<SupermarketParameterOptionDto> dtoList);

  /**
   * 根据parameterId删除
   *
   * @param parameterId
   */
  void deleteByParameterId(String parameterId);
}
