package com.biz.crm.kms.business.supermarket.parameter.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.supermarket.parameter.sdk.dto.SupermarketParameterDto;
import com.biz.crm.kms.business.supermarket.parameter.sdk.dto.SupermarketParameterPageDto;
import com.biz.crm.kms.business.supermarket.parameter.sdk.vo.SupermarketParameterVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 商超抓单参数表(SupermarketParameter)表服务接口
 *
 * @author xi.peng
 * @since 2022-09-23 10:45:21
 */
public interface SupermarketParameterVoService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<SupermarketParameterVo> findByConditions(Pageable pageable, SupermarketParameterPageDto dto);

  /**
   * 条件查询列表
   *
   * @param dto
   * @return
   */
  List<SupermarketParameterVo> findListByConditions(SupermarketParameterDto dto);

  /**
   * 条件查询列表
   *
   * @param supermarketCodes
   * @return
   */
  List<SupermarketParameterVo> findBySupermarketCodes(List<String> supermarketCodes);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  SupermarketParameterVo findDetailById(String id);

  /**
   * 创建
   *
   * @param dto
   * @return
   */
  void create(SupermarketParameterDto dto);

  /**
   * 更新
   *
   * @param dto
   * @return
   */
  void update(SupermarketParameterDto dto);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);
}
