package com.biz.crm.kms.business.supermarket.parameter.sdk.vo;

import com.bizunited.nebula.common.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * 商超抓单参数表抓单方式表vo
 *
 * @author xi.peng
 * @since 2022-09-23 10:47:07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "商超抓单参数表附属选项表Vo")
public class SupermarketParameterGrabModeVo extends TenantVo {

  /**
   * 商超编码
   */
  @ApiModelProperty("商超编码")
  private String supermarketCode;

  /**
   * 单据类型
   */
  @ApiModelProperty("单据类型")
  private String orderType;

  /**
   * 单据名称
   */
  @ApiModelProperty("单据名称")
  private String orderName;

  /**
   * 下载方式（0：单线程，1：多线程）
   */
  @ApiModelProperty("下载方式（0：单线程，1：多线程）")
  private String downloadType;
}

