package com.biz.crm.kms.business.supermarket.parameter.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 商超抓单参数表vo
 *
 * @author xi.peng
 * @since 2022-09-23 10:45:22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "商超抓单参数表Vo")
public class SupermarketParameterVo extends TenantFlagOpVo {

  /**
   * 商超编码
   */
  @ApiModelProperty("商超编码")
  private String supermarketCode;

  /**
   * 接口参数
   */
  @ApiModelProperty("接口参数")
  private String interfaceParameter;

  /**
   * 控件类型（INPUT：单行文本，SELECT：下拉单选，CHECKBOX：下拉多选，DATERANGE：日期范围，DATE：日期单选）
   */
  @ApiModelProperty("控件类型（INPUT：单行文本，SELECT：下拉单选，CHECKBOX：下拉多选，DATERANGE：日期范围，DATE：日期单选）")
  private String controlType;

  /**
   * 参数属性
   */
  @ApiModelProperty("参数属性")
  private String parameterAttr;

  /**
   * 参数文本
   */
  @ApiModelProperty("参数文本")
  private String parameterText;

  /**
   * 提示文本
   */
  @ApiModelProperty("提示文本")
  private String promptText;

  /**
   * 是否显示（0：否，1：是）
   */
  @ApiModelProperty("是否显示（0：否，1：是）")
  private String isShow;

  /**
   * 是否必填（0：否，1：是）
   */
  @ApiModelProperty("是否必填（0：否，1：是）")
  private String isRequired;

  /**
   * 附属标签集合
   */
  @ApiModelProperty("附属标签集合")
  List<SupermarketParameterLabelVo> labelList;

  /**
   * 附属选项集合
   */
  @ApiModelProperty("附属选项集合")
  List<SupermarketParameterOptionVo> optionList;
}

