/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mall.boot.web;

import com.biz.crm.config.SecurityConfig;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.env.ConfigurableEnvironment;

@EnableEurekaClient
@EnableFeignClients(basePackages={"com.biz.crm.*"})
@ComponentScan(basePackages={"com.bizunited.platform.*", "com.biz.crm.*"}, excludeFilters={@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, classes={SecurityConfig.class})})
@SpringBootApplication(scanBasePackages={"com.bizunited.platform.*", "com.biz.crm.*"})
@MapperScan(value={"com.biz.crm.**.mapper*"})
public class MallBootWebApplication {
    private static final Logger log = LoggerFactory.getLogger(MallBootWebApplication.class);

    public static void main(String[] args) {
        System.setProperty("es.set.netty.runtime.available.processors", "false");
        ConfigurableApplicationContext context = SpringApplication.run(MallBootWebApplication.class, (String[])args);
        ConfigurableEnvironment env = context.getEnvironment();
        String port = env.getProperty("server.port");
        String path = env.getProperty("server.servlet.context-path");
        log.info("\n----------------------------------------------------------\n\tApplication crm-cps is running! Access URLs:\n\t\u672c\u5730\u8bbf\u95ee\u5730\u5740: \t\thttp://localhost:" + port + path + "/\n\tswagger\u5730\u5740: \t\thttp://localhost:" + port + path + "/doc.html\n----------------------------------------------------------");
    }
}

