/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mall.commodity.local.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.biz.crm.mall.commodity.local.service.CommodityService;
import com.biz.crm.mall.commodity.local.service.listener.VirtualCardsExcelListener;
import com.biz.crm.mall.commodity.sdk.dto.ChangeStatusDto;
import com.biz.crm.mall.commodity.sdk.dto.CommodityDto;
import com.biz.crm.mall.commodity.sdk.dto.CommodityVirtualDto;
import com.biz.crm.mall.common.sdk.vo.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"commodity"})
@Api(tags={"\u5546\u54c1\u547d\u4ee4\u63a5\u53e3"})
public class CommodityController {
    private static final Logger log = LoggerFactory.getLogger(CommodityController.class);
    private final CommodityService service;

    public CommodityController(CommodityService service) {
        this.service = service;
    }

    @PostMapping
    @ApiOperation(value="\u65b0\u589e\u5546\u54c1\u6570\u636e")
    public Result<?> save(MultipartFile file, CommodityDto dto) {
        if (null != file) {
            InputStream inputStream = null;
            try {
                inputStream = file.getInputStream();
                EasyExcel.read((InputStream)inputStream, CommodityVirtualDto.class, (ReadListener)new VirtualCardsExcelListener(this.service, dto)).sheet().doRead();
            }
            catch (IOException e) {
                log.info(e.getMessage());
                return Result.error((String)"Excel\u52a0\u8f7d\u5931\u8d25");
            }
            catch (Exception e) {
                log.info(e.getMessage());
                return Result.error((String)"Excel\u5b57\u6bb5\u5bf9\u5e94\u9519\u8bef");
            }
        } else {
            this.service.saveOrUpdateWithCards(dto, new CommodityVirtualDto[0]);
        }
        return Result.ok();
    }

    @PatchMapping(value={"updateStatus"})
    @ApiOperation(value="\u5546\u54c1\u542f\u7981\u7528")
    public Result<?> updateStatus(@RequestBody ChangeStatusDto dto) {
        this.service.changeStatus(dto);
        return Result.ok();
    }
}

