/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mall.commodity.local.service.internal;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.biz.crm.mall.commodity.local.entity.GoodsClassify;
import com.biz.crm.mall.commodity.local.mapper.GoodsClassifyMapper;
import com.biz.crm.mall.commodity.local.repository.CommodityClassificationRepository;
import com.biz.crm.mall.commodity.local.service.CommodityClassificationService;
import com.biz.crm.mall.commodity.sdk.constant.CommodityConstant;
import com.biz.crm.mall.commodity.sdk.dto.ChangeStatusDto;
import com.biz.crm.mall.commodity.sdk.dto.CommodityClassificationInsertDto;
import com.biz.crm.mall.commodity.sdk.dto.CommodityClassificationQueryDto;
import com.biz.crm.mall.commodity.sdk.dto.CommodityClassificationUpdateDto;
import com.biz.crm.mall.commodity.sdk.vo.CommodityClassificationVo;
import com.biz.crm.mall.common.sdk.service.CodeService;
import com.biz.crm.mall.common.sdk.service.IdService;
import com.biz.crm.mall.common.sdk.util.Validate;
import java.io.Serializable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional(rollbackFor={RuntimeException.class})
public class CommodityClassificationServiceImpl
implements CommodityClassificationService {
    private final CodeService codeService;
    private final IdService idService;
    private final GoodsClassifyMapper mapper;
    private final CommodityClassificationRepository repository;

    public CommodityClassificationServiceImpl(CodeService codeService, IdService idService, GoodsClassifyMapper mapper, CommodityClassificationRepository repository) {
        this.codeService = codeService;
        this.idService = idService;
        this.mapper = mapper;
        this.repository = repository;
    }

    @Override
    public void save(CommodityClassificationInsertDto dto) {
        Validate.notBlank((CharSequence)dto.getName(), (String)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        boolean isParentIdEmpty = StringUtils.isEmpty((Object)dto.getParentId());
        this.checkDuplicate(dto.getName());
        GoodsClassify classification = new GoodsClassify();
        classification.setId(this.idService.stringId());
        classification.setCode(this.codeService.generateCode("mall_classification"));
        classification.setName(dto.getName());
        classification.setType(isParentIdEmpty ? CommodityConstant.CLASSIFICATION_LEVEL_TOP : CommodityConstant.CLASSIFICATION_LEVEL_CHILD);
        classification.setParentId(isParentIdEmpty ? "0" : dto.getParentId());
        classification.setRemark(dto.getRemark());
        classification.setStatus(CommodityConstant.DISABLE);
        this.checkParentExist(classification.getParentId());
        this.mapper.insert((Object)classification);
    }

    @Override
    public void changeStatus(ChangeStatusDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u542f\u7981\u7528\u5bf9\u8c61id\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.notNull((Object)dto.getStatus(), (String)"\u542f\u7981\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.isTrue((CommodityConstant.ENABLE.equals(dto.getStatus()) || CommodityConstant.DISABLE.equals(dto.getStatus()) ? 1 : 0) != 0, (String)"\u542f\u7981\u7528\u72b6\u6001\u9519\u8bef");
        GoodsClassify classify = (GoodsClassify)((Object)this.repository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)classify), (String)"\u6ca1\u6709\u8be5\u5546\u54c1\u5206\u7c7b");
        Validate.isFalse((boolean)classify.getStatus().equals(dto.getStatus()), (String)"\u4e0d\u9700\u91cd\u590d\u542f\u7981\u7528");
        classify.setStatus(dto.getStatus());
        this.repository.updateById((Object)classify);
    }

    @Override
    public void update(CommodityClassificationUpdateDto dto) {
        Validate.notBlank((CharSequence)dto.getName(), (String)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u5bf9\u8c61id\u4e0d\u80fd\u4e3a\u7a7a");
        boolean isParentIdEmpty = StringUtils.isEmpty((Object)dto.getParentId());
        this.checkDuplicate(dto.getName());
        GoodsClassify classification = (GoodsClassify)((Object)this.repository.getById((Serializable)((Object)dto.getId())));
        Validate.isTrue((boolean)CommodityConstant.DISABLE.equals(classification.getStatus()), (String)"\u8bf7\u5148\u7981\u7528\u518d\u7f16\u8f91");
        classification.setName(dto.getName());
        classification.setType(isParentIdEmpty ? CommodityConstant.CLASSIFICATION_LEVEL_TOP : CommodityConstant.CLASSIFICATION_LEVEL_CHILD);
        classification.setParentId(isParentIdEmpty ? "0" : dto.getParentId());
        classification.setRemark(dto.getRemark());
        this.checkParentExist(classification.getParentId());
        this.repository.updateById((Object)classification);
    }

    private void checkDuplicate(String name) {
        CommodityClassificationQueryDto classificationQueryDto = new CommodityClassificationQueryDto();
        classificationQueryDto.setCodeOrName(name);
        IPage<CommodityClassificationVo> repeat = this.repository.findByCondition(null, classificationQueryDto);
        Validate.isTrue((0L == repeat.getTotal() ? 1 : 0) != 0, (String)"\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
    }

    private void checkParentExist(String parentId) {
        if ("0".equals(parentId)) {
            return;
        }
        GoodsClassify byId = (GoodsClassify)((Object)this.repository.getById((Serializable)((Object)parentId)));
        Validate.notNull((Object)((Object)byId), (String)"\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728");
        Validate.isFalse((boolean)byId.getParentId().equalsIgnoreCase(parentId), (String)"\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u80fd\u662f\u81ea\u5df1");
    }
}

