/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mall.commodity.local.service.internal;

import com.biz.crm.mall.commodity.local.entity.GoodsBase;
import com.biz.crm.mall.commodity.local.mapper.GoodsBaseMapper;
import com.biz.crm.mall.commodity.local.repository.CommodityRepository;
import com.biz.crm.mall.commodity.local.service.CommodityService;
import com.biz.crm.mall.commodity.local.service.CommodityVirtualService;
import com.biz.crm.mall.commodity.sdk.constant.CommodityConstant;
import com.biz.crm.mall.commodity.sdk.dto.ChangeStatusDto;
import com.biz.crm.mall.commodity.sdk.dto.CommodityDto;
import com.biz.crm.mall.commodity.sdk.dto.CommodityVirtualDto;
import com.biz.crm.mall.common.sdk.service.CodeService;
import com.biz.crm.mall.common.sdk.service.IdService;
import com.biz.crm.mall.common.sdk.service.LoginUserService;
import com.biz.crm.mall.common.sdk.util.Validate;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional(rollbackFor={RuntimeException.class})
public class CommodityServiceImpl
implements CommodityService {
    private final GoodsBaseMapper mapper;
    private final CommodityRepository repository;
    private final CommodityVirtualService virtualService;
    private final IdService idService;
    private final CodeService codeService;
    private final LoginUserService userService;

    public CommodityServiceImpl(GoodsBaseMapper mapper, CommodityRepository repository, CommodityVirtualService virtualService, IdService idService, CodeService codeService, LoginUserService userService) {
        this.mapper = mapper;
        this.repository = repository;
        this.virtualService = virtualService;
        this.idService = idService;
        this.codeService = codeService;
        this.userService = userService;
    }

    @Override
    public void saveOrUpdateWithCards(CommodityDto dto, CommodityVirtualDto ... cards) {
        this.saveOrUpdate(dto);
        if (CommodityConstant.COMMODITY_TYPE_VIRTUAL.equals(dto.getType()) && 0 < cards.length) {
            this.virtualService.save(dto.getId(), Arrays.asList(cards));
        }
    }

    @Override
    public void changeStatus(ChangeStatusDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u542f\u7981\u7528\u5bf9\u8c61id\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.notNull((Object)dto.getStatus(), (String)"\u542f\u7981\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.isTrue((CommodityConstant.ENABLE.equals(dto.getStatus()) || CommodityConstant.DISABLE.equals(dto.getStatus()) ? 1 : 0) != 0, (String)"\u542f\u7981\u7528\u72b6\u6001\u9519\u8bef");
        GoodsBase goods = (GoodsBase)((Object)this.repository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)goods), (String)"\u6ca1\u6709\u8be5\u5546\u54c1");
        Validate.isFalse((boolean)goods.getStatus().equals(dto.getStatus()), (String)"\u4e0d\u9700\u91cd\u590d\u542f\u7981\u7528");
        goods.setStatus(dto.getStatus());
        this.repository.updateById((Object)goods);
    }

    private void saveOrUpdate(CommodityDto dto) {
        boolean isSave = StringUtils.isEmpty((Object)dto.getId());
        Validate.notBlank((CharSequence)dto.getName(), (String)"\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.notBlank((CharSequence)dto.getClassId(), (String)"\u5206\u7c7b\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.notBlank((CharSequence)dto.getDetails(), (String)"\u5546\u54c1\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.notBlank((CharSequence)dto.getPictureForCarousel(), (String)"\u5546\u54c1\u8f6e\u64ad\u56fe\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.notBlank((CharSequence)dto.getPictureForList(), (String)"\u5546\u54c1\u5217\u8868\u56fe\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.notBlank((CharSequence)dto.getPictureForDetails(), (String)"\u5546\u54c1\u8be6\u60c5\u56fe\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.notNull((Object)dto.getPrice(), (String)"\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.isTrue((CommodityConstant.COMMODITY_TYPE_REAL.equals(dto.getType()) || CommodityConstant.COMMODITY_TYPE_VIRTUAL.equals(dto.getType()) ? 1 : 0) != 0, (String)"\u5546\u54c1\u7c7b\u578b\u9519\u8bef");
        Validate.isTrue((0L <= dto.getPrice() ? 1 : 0) != 0, (String)"\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        if (isSave) {
            this.save(dto);
        } else {
            this.update(dto);
        }
    }

    private void save(CommodityDto dto) {
        GoodsBase goods = new GoodsBase();
        goods.setId(this.idService.stringId());
        goods.setCode(this.codeService.generateCode(""));
        goods.setName(dto.getName());
        goods.setPictureForList(dto.getPictureForList());
        goods.setPictureForCarousel(dto.getPictureForCarousel());
        goods.setDetails(dto.getDetails());
        goods.setPictureForDetails(dto.getPictureForDetails());
        goods.setType(dto.getType());
        goods.setPrice(dto.getPrice());
        goods.setClassId(dto.getClassId());
        goods.setCreateAccount(this.userService.getLoginAccountName());
        goods.setCreateTime(new Date());
        goods.setStatus(CommodityConstant.DISABLE);
        this.repository.save((Object)goods);
    }

    private void update(CommodityDto dto) {
        GoodsBase goods = (GoodsBase)((Object)this.repository.getById((Serializable)((Object)dto.getId())));
        Validate.isTrue((boolean)CommodityConstant.DISABLE.equals(goods.getStatus()), (String)"\u8bf7\u5148\u7981\u7528\u518d\u7f16\u8f91");
        goods.setName(dto.getName());
        goods.setPictureForList(dto.getPictureForList());
        goods.setPictureForCarousel(dto.getPictureForCarousel());
        goods.setDetails(dto.getDetails());
        goods.setPictureForDetails(dto.getPictureForDetails());
        goods.setType(dto.getType());
        goods.setPrice(dto.getPrice());
        goods.setClassId(dto.getClassId());
        goods.setUpdateAccount(this.userService.getLoginAccountName());
        goods.setUpdateTime(new Date());
        this.repository.updateById((Object)goods);
    }
}

