/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mall.commodity.local.service.internal;

import com.biz.crm.mall.commodity.local.entity.GoodsVirtualInfo;
import com.biz.crm.mall.commodity.local.mapper.GoodsVirtualInfoMapper;
import com.biz.crm.mall.commodity.local.repository.CommodityVirtualRepository;
import com.biz.crm.mall.commodity.local.service.CommodityVirtualService;
import com.biz.crm.mall.commodity.sdk.constant.MallCardCodeRepeatException;
import com.biz.crm.mall.commodity.sdk.dto.CommodityVirtualDto;
import com.biz.crm.mall.common.sdk.service.IdService;
import com.biz.crm.mall.common.sdk.util.Validate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class CommodityVirtualServiceImpl
implements CommodityVirtualService {
    private final GoodsVirtualInfoMapper mapper;
    private final CommodityVirtualRepository repository;
    private final IdService idService;

    public CommodityVirtualServiceImpl(GoodsVirtualInfoMapper mapper, CommodityVirtualRepository repository, IdService idService) {
        this.mapper = mapper;
        this.repository = repository;
        this.idService = idService;
    }

    @Override
    public void save(String commodityId, List<CommodityVirtualDto> list) {
        Validate.notBlank((CharSequence)commodityId, (String)"\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.notNull(list, (String)"\u5361\u5238\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.isFalse((boolean)list.isEmpty(), (String)"\u5361\u5238\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        String[] codes = (String[])list.stream().map(CommodityVirtualDto::getCode).toArray();
        List<String> repeatCodes = this.repository.findRepeatCodes(codes);
        if (!repeatCodes.isEmpty()) {
            StringBuilder builder = new StringBuilder().append("\u4ee5\u4e0b\u5361\u5238\u7f16\u7801\u91cd\u590d:");
            repeatCodes.forEach(c -> builder.append(c + ","));
            builder.deleteCharAt(builder.length() - 1);
            throw new MallCardCodeRepeatException(builder.toString());
        }
        ArrayList<GoodsVirtualInfo> infos = new ArrayList<GoodsVirtualInfo>(list.size());
        for (CommodityVirtualDto dto : list) {
            GoodsVirtualInfo info = new GoodsVirtualInfo();
            info.setId(this.idService.stringId());
            info.setGoodsId(commodityId);
            info.setCode(dto.getCode());
            info.setName(dto.getName());
            info.setPassword(dto.getPassword());
            info.setIssue(dto.getIssue());
            info.setCreateTime(new Date());
            infos.add(info);
        }
        this.repository.saveBatch(infos);
    }
}

