package com.biz.crm.market.business.bidding.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.UuidFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 招标过程详细dto
 *
 * @author hzh
 * @date 2021.11.01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "招标过程详细dto")
public class BiddingProcessDetailDto extends UuidFlagOpDto {


        @ApiModelProperty("招标过程编码")
        private String biddingProcessCode;

        @ApiModelProperty("产品编码,用来关联产品明细")
        private String productCode;

        @ApiModelProperty("投标企业编码")
        private String biddingEnterpriseCode;

        @ApiModelProperty("投标企业名称")
        private String biddingEnterpriseName;

        @ApiModelProperty("省份编码,用来关联省份")
        private String provinceCode;

        @ApiModelProperty("省份名称")
        private String provinceName;

        @ApiModelProperty("挂网平台(原区域)编码")
        private String areaCode;

        @ApiModelProperty("挂网平台(原区域)名称")
        private String areaName;

        @ApiModelProperty("中标状态")
        private String bidStatus;

        @ApiModelProperty("单据状态编码")
        private String documentStatus;

        @ApiModelProperty("生效状态编码")
        private String effectiveStatus;

        @ApiModelProperty("是否历史")
        private Boolean effective;

        @ApiModelProperty("约定购买量")
        private BigDecimal agreedPurchase;

        @ApiModelProperty("是否特殊价格")
        private Boolean specialPrice;

        @ApiModelProperty("是否参与")
        private Boolean participate;

        @ApiModelProperty("执行开始日期")
        @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
        @DateTimeFormat(pattern = "yyyy-MM-dd")
        private Date executionBeginDate;

        @ApiModelProperty("执行结束日期")
        @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
        @DateTimeFormat(pattern = "yyyy-MM-dd")
        private Date executionEndDate;

}
