package com.biz.crm.market.business.bidding.sdk.dto;

import com.biz.crm.business.common.sdk.dto.UuidFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;
import java.util.List;

/**
 * 招标过程明细查询dto
 *
 * @author hzh
 * @date 2021.11.01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "招标过程明细查询dto")
public class BiddingProcessDetailSelectDto {

        @ApiModelProperty("招标过程编码")
        private String biddingProcessCode;

        @ApiModelProperty("生效状态")
        private String effectiveStatus;

        @ApiModelProperty("产品编码")
        private String productCode;

        @ApiModelProperty("产品编码或名称")
        private String projectNameOrCode;

        @ApiModelProperty("省份编码")
        private String provinceCode;

        @ApiModelProperty("省份名称")
        private String provinceName;

        @ApiModelProperty("省份id")
        private String provinceId;

        @ApiModelProperty("是否要使用区域编码进行查询，默认为不")
        private Boolean selectArea = false;

        // 该字段查询时若为null，那就用null查询
        // 挂网平台不是投标企业，而是区域，不再用投标企业来查询跟挂网平台有关的东西，转为用区域查
        @ApiModelProperty("挂网平台(原区域)编码")
        private String areaCode;

        @ApiModelProperty("执行开始日期")
        @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
        @DateTimeFormat(pattern = "yyyy-MM-dd")
        private Date executionBeginDate;

        @ApiModelProperty("执行开始日期(小于判断)")
        @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
        @DateTimeFormat(pattern = "yyyy-MM-dd")
        private Date ltExecutionBeginDate;

        @ApiModelProperty("需要过滤的生效状态")
        private List<String> filterEffectiveStatusList;


}
