package com.biz.crm.market.business.bidding.sdk.dto;

import com.biz.crm.business.common.sdk.dto.UuidFlagOpDto;
import com.biz.crm.market.business.bidding.sdk.vo.BiddingProcessMediaVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.util.List;

/**
 * 招标过程dto
 *
 * @author hzh
 * @date 2021.10.27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "招标过程dto")
public class BiddingProcessDto extends UuidFlagOpDto {

        /** 招标过程编码 */
        @ApiModelProperty("招标过程编码")
        private String biddingProcessCode;

        /** 所属项目编码 */
        @ApiModelProperty("所属项目编码")
        private String projectCode;

        /** 采招类型 */
        @ApiModelProperty("采招类型")
        private String recruitmentType;

        @ApiModelProperty("招标过程状态")
        private String biddingProcessStatus;

        /** 招标过程产品信息 */
        @ApiModelProperty("招标过程产品信息")
        private List<BiddingProcessProductDto> biddingProcessProductDtos;

        @ApiModelProperty("要删除的招标过程产品信息id")
        private List<String> deleteProductIds;

        @ApiModelProperty("要删除的招标过程省份id")
        private List<String> deleteProvinceIds;

        /** 招标过程省份 */
        @ApiModelProperty("招标过程省份")
        private List<BiddingProcessProvinceDto> biddingProcessProvinceDtos;

        /** 招标过程详情 */
        @ApiModelProperty("招标过程详情")
        private List<BiddingProcessDetailDto> biddingProcessDetailDtos;

        /** 项目附件 */
        @ApiModelProperty("招标附件")
        private List<BiddingProcessMediaDto> biddingProcessMedias;

        @ApiModelProperty("产品附件")
        private List<BiddingProcessMediaDto> biddingProcessProductMedias;

        @ApiModelProperty("省份附件")
        private List<BiddingProcessMediaDto> biddingProcessProvinceMedias;

}
