package com.biz.crm.market.business.bidding.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.FileDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 招标过程附件实体类
 *
 * @author hzh
 * @date 2021.10.27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "招标过程附件dto")
public class BiddingProcessMediaDto extends FileDto {

        /** 招标过程编码 */
        @ApiModelProperty("招标过程编码")
        private String biddingProcessCode;

        @ApiModelProperty("文件类型")
        private String type;

        @ApiModelProperty("附件类型")
        private String mediaType;

        @ApiModelProperty("文件地址")
        private String url;

}
