package com.biz.crm.market.business.bidding.sdk.dto;

import com.biz.crm.business.common.sdk.dto.UuidFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;

/**
 * 招标过程产品信息dto
 *
 * @author hzh
 * @date 2021.10.27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "招标过程产品信息dto")
public class BiddingProcessProductDto extends UuidFlagOpDto {

        /** 招标过程编码 */
        @ApiModelProperty("招标过程编码")
        private String biddingProcessCode;

        /** 产品编码 */
        @ApiModelProperty("产品编码")
        private String productCode;

        /** 投标企业编码 */
        @ApiModelProperty("投标企业编码")
        private String biddingEnterpriseCode;

        @ApiModelProperty("投标企业名称")
        private String biddingEnterpriseName;

        /** 拟申报价 */
        @ApiModelProperty("拟申报价")
        private BigDecimal proposedQuotation;

        /** 申报建议 */
        @ApiModelProperty("申报建议")
        private String declarationProposal;

        /** 审批结果 */
        @ApiModelProperty("审批结果")
        private String approvalResults;

        /** 最终报价 */
        @ApiModelProperty("最终报价")
        private BigDecimal finalQuotation;

        @ApiModelProperty("中标状态")
        private String bidStatus;

        /** 中标价格 */
        @ApiModelProperty("中标价格")
        private BigDecimal bidPrice;

        /** 备注 */
        @ApiModelProperty("备注")
        private String remark;

        // 以下为产品冗余字段
        @ApiModelProperty("产品名称")
        private String productName;

        @ApiModelProperty("剂型编码")
        private String dosageFormCode;

        @ApiModelProperty("剂型说明")
        private String dosageFormExplain;

        @ApiModelProperty("规格")
        private String specifications;

        @ApiModelProperty("生产企业编码")
        private String enterpriseCode;

        @ApiModelProperty("生产企业名称")
        private String enterpriseName;

        @ApiModelProperty("转换系数")
        private String conversionFactor;

}
