package com.biz.crm.market.business.bidding.sdk.dto;

import com.biz.crm.business.common.sdk.dto.UuidFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 招标过程省份dto
 *
 * @author hzh
 * @date 2021.10.27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "招标过程省份dto")
public class BiddingProcessProvinceDto extends UuidFlagOpDto {

        /** 招标过程编码 */
        @ApiModelProperty("招标过程编码")
        private String biddingProcessCode;

        /** 省份编码 */
        @ApiModelProperty("省份编码")
        private String provinceCode;

        /** 省份名称 */
        @ApiModelProperty("省份名称")
        private String provinceName;

        /** 挂网平台(原区域)编码 */
        @ApiModelProperty("挂网平台(原区域)编码")
        private String areaCode;

        /** 挂网平台(原区域)名称 */
        @ApiModelProperty("挂网平台(原区域)名称")
        private String areaName;

        /** 公告日期 */
        @ApiModelProperty("公告日期")
        private String announcementDate;

        /** 执行开始日期 */
        @ApiModelProperty("执行开始日期")
        @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
        @DateTimeFormat(pattern = "yyyy-MM-dd")
        private Date executionBeginDate;

        /** 执行结束日期 */
        @ApiModelProperty("执行结束日期")
        @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
        @DateTimeFormat(pattern = "yyyy-MM-dd")
        private Date executionEndDate;

}
