package com.biz.crm.market.business.bidding.sdk.dto;

import com.biz.crm.business.common.sdk.dto.UuidFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 招标过程dto
 *
 * @author hzh
 * @date 2021.10.27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "招标过程dto")
public class BiddingProcessSelectDto extends UuidFlagOpDto {

        /** 招标过程编码 */
        @ApiModelProperty("招标过程编码")
        private String biddingProcessCode;

        /** 所属项目编码 */
        @ApiModelProperty("所属项目编码")
        private String projectCode;

        /** 所属项目名称 */
        @ApiModelProperty("所属项目名称")
        private String projectName;

        /** 所属项目说明 */
        @ApiModelProperty("所属项目说明")
        private String projectExplain;

        /** 采招类型 */
        @ApiModelProperty("采招类型")
        private String recruitmentType;

        /** 所属项目年份 */
        @ApiModelProperty("所属项目年份")
        private String projectYear;

}
