package com.biz.crm.market.business.bidding.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * 审批结果
 * @author hezhiheng
 * @date 2022.10.31
 */
@Getter
@AllArgsConstructor
public enum ApprovalResultsEnum {
    /** 同意申报 */
    SUCCESS("success","同意申报"),
    /** 不申报 */
    FAIL("fail","不申报"),
    ;

    private String code;
    private String des;

    /**
     * 根据code获取枚举
     *
     * @param code
     * @return
     */
    public static ApprovalResultsEnum getByKey(String code) {
        return Arrays.stream(ApprovalResultsEnum.values()).filter(item -> Objects.equals(item.getCode(), code))
                .findFirst().orElse(null);
    }
}
